/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin;

import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractGlossaryMojo;
import ch.ifocusit.livingdoc.plugin.mapping.DomainObject;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="dictionary", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class DictionaryMojo
extends AbstractGlossaryMojo {
    @Override
    protected String getDefaultFilename() {
        return "dictionary";
    }

    @Override
    protected String getTitle() {
        return "Dictionary";
    }

    @Override
    protected void executeMojo(Stream<DomainObject> domainObjects) {
        List rows = domainObjects.map(def -> {
            String idColumn = def.getId() == null ? "" : this.formatAndLink("<<{2},{0}>>", (DomainObject)def);
            return Lists.newArrayList((Object[])new String[]{idColumn, this.formatAndLink("<<{2},{1}>>", (DomainObject)def), def.getDescription()});
        }).map(field -> field.stream().collect(Collectors.joining("|"))).collect(Collectors.toList());
        rows.add(0, "id|name|description");
        this.asciiDocBuilder.tableWithHeaderRow(rows);
    }
}

