/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.baseMojo;

import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractAsciidoctorMojo;
import io.github.robwin.markup.builder.asciidoc.AsciiDocBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;

public abstract class AbstractDocsGeneratorMojo
extends AbstractAsciidoctorMojo {
    public static final String GLOSSARY_ANCHOR = "glossaryid-{0}";
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="html")
    protected AbstractAsciidoctorMojo.Format format;
    @Parameter(defaultValue="glossaryid-{0}")
    protected String glossaryAnchorTemplate;
    @Parameter
    protected File glossaryMapping;
    @Parameter(defaultValue="false")
    protected boolean onlyAnnotated = false;
    @Parameter
    private String outputFilename;

    protected abstract String getDefaultFilename();

    protected void write(String newContent, File output) throws MojoExecutionException {
        try {
            output.getParentFile().mkdirs();
            IOUtils.write((String)newContent, (OutputStream)new FileOutputStream(output), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Unable to write output file '%s' !", output), (Exception)e);
        }
    }

    protected void write(AsciiDocBuilder asciiDocBuilder) throws MojoExecutionException {
        this.write(asciiDocBuilder, this.format, this.getOutputFilename());
    }

    public String getOutputFilename() {
        return StringUtils.defaultString((String)this.outputFilename, (String)this.getDefaultFilename());
    }

    protected AsciiDocBuilder createAsciiDocBuilder() {
        AsciiDocBuilder asciiDocBuilder = new AsciiDocBuilder();
        asciiDocBuilder.textLine(":sectlinks:");
        asciiDocBuilder.textLine(":sectanchors:");
        return asciiDocBuilder;
    }
}

