/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.mapping;

import ch.ifocusit.livingdoc.annotations.UbiquitousLanguage;
import ch.ifocusit.livingdoc.plugin.mapping.DomainObject;
import ch.ifocusit.livingdoc.plugin.utils.AnchorUtil;
import ch.ifocusit.livingdoc.plugin.utils.AnnotationUtil;
import ch.ifocusit.plantuml.classdiagram.NamesMapper;
import ch.ifocusit.plantuml.classdiagram.model.Link;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.simpleflatmapper.csv.CsvParser;

public class GlossaryNamesMapper<A extends UbiquitousLanguage>
implements NamesMapper {
    List<DomainObject> mappings = new ArrayList<DomainObject>();
    private Class<A> annotation;
    private String linkTemplate;

    public GlossaryNamesMapper(File file, Class<A> annotation, String linkTemplate) throws IOException {
        this.annotation = annotation;
        this.linkTemplate = linkTemplate;
        if (file != null) {
            this.mappings = CsvParser.mapTo(DomainObject.class).stream((Reader)new FileReader(file)).collect(Collectors.toList());
        }
    }

    private Optional<String> getName(int id) {
        return this.mappings.stream().filter(def -> def.getId() == id).findFirst().map(DomainObject::getName);
    }

    public String getClassName(Class aClass) {
        int id = AnnotationUtil.tryFind(aClass, this.annotation).map(UbiquitousLanguage::id).orElse(-1);
        return this.getName(id).orElse(super.getClassName(aClass));
    }

    public Optional<Link> getClassLink(Class aClass) {
        return Optional.of(this.create(this.getClassName(aClass), aClass.getSimpleName(), AnnotationUtil.tryFind(aClass, this.annotation)));
    }

    public String getFieldName(Field field) {
        int id = AnnotationUtil.tryFind(field, this.annotation).map(UbiquitousLanguage::id).orElse(-1);
        return this.getName(id).orElse(super.getFieldName(field));
    }

    public String getFieldFullName(Field field) {
        return field.getDeclaringClass().getSimpleName() + "." + field.getName();
    }

    public Optional<Link> getFieldLink(Field field) {
        return Optional.of(this.create(this.getFieldName(field), this.getFieldFullName(field), AnnotationUtil.tryFind(field, this.annotation)));
    }

    private Link create(String name, String fullName, Optional<A> annotation) {
        Link link = new Link();
        link.setLabel(name);
        link.setUrl(AnchorUtil.formatLink(this.linkTemplate, annotation.map(a -> a.id()).orElse(null), fullName));
        return link;
    }
}

