/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.baseMojo;

import ch.ifocusit.livingdoc.annotations.UbiquitousLanguage;
import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractAsciidoctorMojo;
import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractDocsGeneratorMojo;
import ch.ifocusit.livingdoc.plugin.mapping.DomainObject;
import ch.ifocusit.livingdoc.plugin.utils.AnchorUtil;
import ch.ifocusit.livingdoc.plugin.utils.ClassLoaderUtil;
import ch.ifocusit.livingdoc.plugin.utils.StringUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import io.github.robwin.markup.builder.asciidoc.AsciiDocBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.simpleflatmapper.csv.CsvParser;

public abstract class AbstractGlossaryMojo
extends AbstractDocsGeneratorMojo {
    protected static final String GLOSSARY_LINK_TITLE = "[[{2}]]\n=== #{0}# - {1}";
    protected static final String GLOSSARY_LINK_TITLE_LITE = "[[{2}]]\n=== {1}";
    protected static final String GLOSSARY_LINK_INLINE_ID = "<<{2},{0}>>";
    protected static final String GLOSSARY_LINK_INLINE_NAME = "<<{2},{1}>>";
    @Parameter
    protected String glossaryTitleTemplate;
    protected AsciiDocBuilder asciiDocBuilder = this.createAsciiDocBuilder();
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private List<String> sources = new ArrayList<String>();
    @Parameter
    private String packageRoot = "";
    private JavaProjectBuilder javaDocBuilder;
    private List<DomainObject> mappings;

    private static Function<DomainObject, ?> key() {
        return def -> def.getId() == null ? def.getName() : def.getId();
    }

    private static Predicate<DomainObject> distinctByKey() {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(AbstractGlossaryMojo.key().apply((DomainObject)t), Boolean.TRUE) == null;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.javaDocBuilder = this.buildJavaProjectBuilder();
        if (AbstractAsciidoctorMojo.Format.html.equals((Object)this.format)) {
            this.asciiDocBuilder.sectionTitleLevel1(this.getTitle());
        }
        if (this.glossaryMapping != null) {
            try {
                this.mappings = CsvParser.mapTo(DomainObject.class).stream((Reader)new FileReader(this.glossaryMapping)).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new MojoExecutionException("error reading mappings file", (Exception)e);
            }
        }
        ArrayList definitions = new ArrayList();
        this.getClasses().forEach(javaClass -> {
            definitions.add(this.map((JavaClass)javaClass));
            javaClass.getFields().stream().filter(this::hasAnnotation).forEach(javaField -> definitions.add(this.map((JavaField)javaField)));
        });
        this.executeMojo(definitions.stream().sorted().filter(AbstractGlossaryMojo.distinctByKey()));
        this.write(this.asciiDocBuilder);
    }

    protected abstract String getTitle();

    protected abstract void executeMojo(Stream<DomainObject> var1);

    private Stream<JavaClass> getClasses() {
        return this.javaDocBuilder.getClasses().stream().filter(javaClass -> this.packageRoot == null || javaClass.getPackageName().startsWith(this.packageRoot)).filter(this::hasAnnotation);
    }

    private boolean hasAnnotation(JavaAnnotatedElement annotatedElement) {
        return !this.onlyAnnotated || this.getGlossary(annotatedElement).isPresent();
    }

    private Optional<JavaAnnotation> getGlossary(JavaAnnotatedElement annotatedElement) {
        return annotatedElement.getAnnotations().stream().filter(a -> a.getType().getFullyQualifiedName().endsWith(UbiquitousLanguage.class.getSimpleName())).findFirst();
    }

    private Optional<Integer> getGlossaryId(JavaAnnotatedElement annotatedElement) {
        Optional<JavaAnnotation> annotation = this.getGlossary(annotatedElement);
        return annotation.map((? super T annot) -> annot.getProperty("id") == null ? null : Optional.ofNullable(Integer.valueOf(String.valueOf(annot.getNamedParameter("id"))))).orElse(Optional.empty());
    }

    private Optional<DomainObject> getMapping(JavaAnnotatedElement annotatedElement) {
        Optional<Integer> id = this.getGlossaryId(annotatedElement);
        return this.mappings == null || !id.isPresent() ? Optional.empty() : this.mappings.stream().filter(def -> ((Integer)id.get()).equals(def.getId())).findFirst();
    }

    private String getName(JavaAnnotatedElement annotatedElement, String defaultValue) {
        return this.getMapping(annotatedElement).map(DomainObject::getName).orElse(defaultValue);
    }

    private String getDescription(JavaAnnotatedElement annotatedElemen, String defaultValue) {
        return this.getMapping(annotatedElemen).map(DomainObject::getDescription).orElse(defaultValue);
    }

    private JavaProjectBuilder buildJavaProjectBuilder() throws MojoExecutionException {
        JavaProjectBuilder javaDocBuilder = new JavaProjectBuilder();
        javaDocBuilder.setEncoding(Charset.defaultCharset().toString());
        javaDocBuilder.setErrorHandler(e -> this.getLog().warn((CharSequence)e.getMessage()));
        this.sources.stream().map(File::new).forEach(arg_0 -> ((JavaProjectBuilder)javaDocBuilder).addSourceTree(arg_0));
        javaDocBuilder.addClassLoader(ClassLoaderUtil.getRuntimeClassLoader(this.project));
        this.loadSourcesDependencies(javaDocBuilder);
        return javaDocBuilder;
    }

    private void loadSourcesDependencies(JavaProjectBuilder javaDocBuilder) {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
        Stream.concat(this.project.getDependencies().stream(), this.project.getPlugin(pluginDescriptor.getPluginLookupKey()).getDependencies().stream()).forEach(dependency -> {
            Artifact sourcesArtifact = this.repositorySystem.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), "sources");
            this.loadSourcesDependency(javaDocBuilder, sourcesArtifact);
        });
    }

    private void loadSourcesDependency(JavaProjectBuilder javaDocBuilder, Artifact sourcesArtifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(sourcesArtifact);
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        result.getArtifacts().forEach(artifact -> {
            try {
                JarFile jarFile = new JarFile(artifact.getFile());
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".java") || name.endsWith("/package-info.java")) continue;
                    javaDocBuilder.addSource(new URL("jar:" + artifact.getFile().toURI().toURL().toString() + "!/" + name));
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Unable to load jar source " + artifact), (Throwable)e);
            }
        });
    }

    protected String formatAndLink(String textTemplate, DomainObject domainObject) {
        String anchorLink = AnchorUtil.formatLink(this.glossaryAnchorTemplate, domainObject.getId(), domainObject.getFullName());
        return StringUtil.interpretNewLine(MessageFormat.format(textTemplate, StringUtil.defaultString(domainObject.getId(), ""), domainObject.getFullName(), anchorLink));
    }

    private DomainObject createMappingDefinition(JavaAnnotatedElement model, String name) {
        DomainObject domainObject = new DomainObject();
        domainObject.setId(this.getGlossaryId(model).orElse(null));
        domainObject.setName(this.getName(model, name));
        domainObject.setDescription(this.getDescription(model, model.getComment()));
        domainObject.setMapped(this.getMapping(model).isPresent());
        return domainObject;
    }

    private DomainObject map(JavaClass model) {
        DomainObject domainObject = this.createMappingDefinition((JavaAnnotatedElement)model, model.getName());
        domainObject.setNamespace(model.getPackageName());
        return domainObject;
    }

    private DomainObject map(JavaField model) {
        DomainObject domainObject = this.createMappingDefinition((JavaAnnotatedElement)model, model.getName());
        domainObject.setParentName(model.getDeclaringClass().getName());
        domainObject.setNamespace(model.getDeclaringClass().getPackageName());
        return domainObject;
    }
}

