/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin;

import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractGlossaryMojo;
import ch.ifocusit.livingdoc.plugin.mapping.DomainObject;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="dictionary", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class DictionaryMojo
extends AbstractGlossaryMojo {
    @Parameter(defaultValue="dictionary", required=true)
    private String dictionaryOutputFilename;
    @Parameter
    private String dictionaryTitle;

    @Override
    protected String getOutputFilename() {
        return this.dictionaryOutputFilename;
    }

    @Override
    protected String getTitle() {
        return this.dictionaryTitle;
    }

    @Override
    protected void executeMojo() {
        ArrayList definitions = new ArrayList();
        this.getClasses().forEach(javaClass -> {
            definitions.add(this.map((JavaClass)javaClass));
            javaClass.getFields().stream().filter(this::hasAnnotation).forEach(javaField -> definitions.add(this.map((JavaField)javaField)));
        });
        definitions.stream().sorted().filter(DictionaryMojo.distinctByKey()).forEach(this::addGlossarEntry);
    }

    private void addGlossarEntry(DomainObject domainObject) {
        this.asciiDocBuilder.textLine(this.formatAndLink(StringUtils.defaultString((String)this.glossaryTitleTemplate, (String)(domainObject.getId() != null ? GLOSSARY_LINK_TITLE : GLOSSARY_LINK_TITLE_LITE)), domainObject));
        this.asciiDocBuilder.textLine(domainObject.getFullDescription());
        this.asciiDocBuilder.textLine("");
    }
}

