/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin;

import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractGlossaryMojo;
import ch.ifocusit.livingdoc.plugin.glossary.JavaClass;
import ch.ifocusit.livingdoc.plugin.utils.MustacheUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="glossary", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class GlossaryMojo
extends AbstractGlossaryMojo {
    private static final String DEFAULT_GLOSSARY_TEMPLATE_MUSTACHE = "/default_glossary_template.mustache";
    @Parameter(defaultValue="glossary", required=true)
    private String glossaryOutputFilename;
    @Parameter
    private String glossaryTitle;
    @Parameter(defaultValue="Id|Object Name|Attribute name|Type|Description|Constraints|Default Value")
    private String glossaryColumnsName;
    @Parameter
    private File glossaryTemplate;
    @Parameter(defaultValue="true")
    private boolean glossaryWithLink = true;

    @Override
    protected String getOutputFilename() {
        return this.glossaryOutputFilename;
    }

    @Override
    protected String getTitle() {
        return this.glossaryTitle;
    }

    @Override
    protected void executeMojo() throws Exception {
        List classes = this.getClasses().map((? super T javaClass) -> JavaClass.from(javaClass, this::hasAnnotation, this.getClasses().collect(Collectors.toList()))).collect(Collectors.toList());
        boolean withId = classes.stream().anyMatch(JavaClass::hasId);
        HashMap<String, Object> scopes = new HashMap<String, Object>();
        scopes.put("columnsName", withId ? this.glossaryColumnsName : this.glossaryColumnsName.replace("Id|", ""));
        scopes.put("columnsSize", (withId ? "1," : "") + "1,1,1,2,1,1");
        scopes.put("classes", classes);
        scopes.put("withLink", this.glossaryWithLink);
        this.asciiDocBuilder.textLine(MustacheUtil.execute(this.glossaryTemplate, DEFAULT_GLOSSARY_TEMPLATE_MUSTACHE, scopes));
    }
}

