/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.glossary;

import ch.ifocusit.livingdoc.annotations.UbiquitousLanguage;
import ch.ifocusit.livingdoc.plugin.utils.AsciidocUtil;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaAnnotation;
import io.github.robwin.markup.builder.asciidoc.AsciiDoc;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.stream.Collectors;

public interface JavaElement {
    public static final String JAVAX_VALIDATION_CONSTRAINTS = "javax.validation.constraints.";
    public static final String HIBERNATE_VALIDATION_CONSTRAINTS = "org.hibernate.validator.constraints.";

    public String getName();

    public String getType();

    public JavaAnnotatedElement getModel();

    default public String getDescription() {
        return this.getModel().getComment();
    }

    default public String getAnchor(String id) {
        return "anchor:" + MessageFormat.format("glossaryid-{0}", id) + "[]";
    }

    default public String getLinkableName() {
        return this.getAnchor(this.getName()) + this.getName();
    }

    default public String getAnnotations() {
        return this.getModel().getAnnotations().stream().filter(annot -> annot.getType().getFullyQualifiedName().startsWith(JAVAX_VALIDATION_CONSTRAINTS) || annot.getType().getFullyQualifiedName().startsWith(HIBERNATE_VALIDATION_CONSTRAINTS)).map(annot -> annot.toString().replace(JAVAX_VALIDATION_CONSTRAINTS, "").replace(HIBERNATE_VALIDATION_CONSTRAINTS, "")).collect(Collectors.joining(AsciidocUtil.NEWLINE + AsciidocUtil.NEWLINE));
    }

    default public Optional<JavaAnnotation> getGlossary() {
        return this.getModel().getAnnotations().stream().filter(a -> a.getType().getFullyQualifiedName().endsWith(UbiquitousLanguage.class.getSimpleName())).findFirst();
    }

    default public Optional<Integer> getGlossaryId() {
        Optional<JavaAnnotation> annotation = this.getGlossary();
        return annotation.map(annot -> annot.getProperty("id") == null ? null : Optional.ofNullable(Integer.valueOf(String.valueOf(annot.getNamedParameter("id"))))).orElse(Optional.empty());
    }

    default public String getLinkableIdColumn() {
        return this.getGlossaryId().map(id -> AsciiDoc.TABLE_COLUMN_DELIMITER + this.getAnchor(String.valueOf(id)) + String.valueOf(id)).orElse("");
    }
}

