/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.glossary;

import ch.ifocusit.livingdoc.plugin.glossary.JavaElement;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaClass;
import java.text.MessageFormat;
import java.util.List;

public class JavaField
implements JavaElement {
    private com.thoughtworks.qdox.model.JavaField model;
    private boolean partOfDomain = false;

    @Override
    public String getName() {
        return this.model.getName();
    }

    @Override
    public String getType() {
        if (this.model.isEnumConstant()) {
            return "";
        }
        String typeName = this.model.getType().getName();
        if (this.model.getType().isEnum()) {
            typeName = typeName + ", Enumeration";
        }
        return typeName;
    }

    @Override
    public JavaAnnotatedElement getModel() {
        return this.model;
    }

    public boolean isPartOfDomain() {
        return this.partOfDomain;
    }

    public String getLinkedType() {
        if (this.model.isEnumConstant()) {
            return "";
        }
        String name = this.model.getType().getName();
        if (this.isPartOfDomain()) {
            name = "<<" + MessageFormat.format("glossaryid-{0}", this.model.getType().getName()) + "," + this.model.getType().getName() + ">>";
        }
        if (this.model.getType().isEnum()) {
            name = name + ", Enumeration";
        }
        return name;
    }

    public static JavaField of(com.thoughtworks.qdox.model.JavaField javaField, List<JavaClass> domainClasses) {
        JavaField field = new JavaField();
        field.model = javaField;
        field.partOfDomain = domainClasses.stream().anyMatch(javaField.getType()::equals);
        return field;
    }
}

