/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public class Template {
    @Parameter(required=true)
    private File template;
    @Parameter(required=true, defaultValue="{value}")
    private String token;

    public static Template create(URL url) {
        try {
            Template parameter = new Template();
            parameter.template = new File(url.toURI());
            return parameter;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String process(String value) throws MojoExecutionException {
        try {
            String content = IOUtils.toString((InputStream)new FileInputStream(this.template), (Charset)Charset.defaultCharset());
            if (StringUtils.isBlank((CharSequence)content)) {
                throw new MojoExecutionException(String.format("Template founded (%s) but empty !", this.template));
            }
            if (!content.contains(this.token)) {
                throw new MojoExecutionException(String.format("1Token '%s' is not present in template file !", this.token));
            }
            return content.replace(this.token, value);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(String.format("Remplate file not found (%s) !", this.template), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Error during process template file (%s) !", this.template), (Exception)e);
        }
    }
}

