/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.diagram;

import ch.ifocusit.livingdoc.annotations.RootAggregate;
import ch.ifocusit.livingdoc.plugin.diagram.AbstractClassDiagramBuilder;
import ch.ifocusit.livingdoc.plugin.domain.Color;
import ch.ifocusit.livingdoc.plugin.utils.AnnotationUtil;
import ch.ifocusit.livingdoc.plugin.utils.AsciidocUtil;
import ch.ifocusit.plantuml.classdiagram.ClassDiagramBuilder;
import ch.ifocusit.plantuml.classdiagram.LinkMaker;
import ch.ifocusit.plantuml.classdiagram.model.clazz.JavaClazz;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class PlantumlClassDiagramBuilder
extends AbstractClassDiagramBuilder {
    private ClassDiagramBuilder classDiagramBuilder;
    private Predicate<ClassPath.ClassInfo> additionalClassPredicate = a -> true;
    private boolean showMethods;
    private boolean showFields;

    public PlantumlClassDiagramBuilder(MavenProject project, String prefix, String[] excludes, final Color rootAggregateColor, File header, File footer, boolean showMethods, boolean showFields, boolean diagramWithDependencies, String linkPage) {
        super(project, prefix, excludes, header, footer, diagramWithDependencies, linkPage);
        this.showMethods = showMethods;
        this.showFields = showFields;
        this.classDiagramBuilder = new ClassDiagramBuilder(){

            protected JavaClazz createJavaClass(Class clazz) {
                JavaClazz javaClass = super.createJavaClass(clazz);
                if (rootAggregateColor != null) {
                    AnnotationUtil.tryFind(clazz, RootAggregate.class).ifPresent(annot -> javaClass.setBackgroundColor(rootAggregateColor.getBackgroundColor()).setBorderColor(rootAggregateColor.getBorderColor()));
                }
                return javaClass;
            }
        };
    }

    @Override
    public String generate() throws MojoExecutionException {
        ClassPath classPath = this.initClassPath();
        ImmutableSet allClasses = classPath.getTopLevelClassesRecursive(this.prefix);
        String diagram = this.classDiagramBuilder.addClasse((Iterable)allClasses.stream().filter(this.defaultFilter()).filter(this.additionalClassPredicate).map(ClassPath.ClassInfo::load).collect(Collectors.toList())).excludes(this.excludes).setHeader(this.readHeader()).setFooter(this.readFooter()).withNamesMapper(this.namesMapper).withLinkMaker((LinkMaker)this).withDependencies(this.diagramWithDependencies).build();
        return diagram;
    }

    @Override
    protected String readHeader() throws MojoExecutionException {
        String header = super.readHeader();
        header = header + (this.showFields ? "" : "hide fields" + AsciidocUtil.NEWLINE);
        header = header + (this.showMethods ? "" : "hide methods" + AsciidocUtil.NEWLINE);
        return header;
    }

    @Override
    public void filterOnAnnotation(Class<? extends Annotation> annotation) {
        if (annotation == null) {
            return;
        }
        this.additionalClassPredicate = this.additionalClassPredicate.and(classInfo -> classInfo.load().isAnnotationPresent(annotation));
        this.classDiagramBuilder.addFieldPredicate(attribut -> attribut.getField().isAnnotationPresent(annotation));
    }
}

