/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.stream.Collectors;

public final class InputStreamUtils {
    private InputStreamUtils() {
        throw new UnsupportedOperationException("Utils class cannot be instantiated");
    }

    public static String inputStreamAsString(InputStream is) {
        String string;
        BufferedReader buffer = new BufferedReader(new InputStreamReader(is));
        try {
            string = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not convert InputStream to String ", e);
            }
        }
        buffer.close();
        return string;
    }

    public static FileInputStream fileInputStream(Path filePath) {
        try {
            return new FileInputStream(filePath.toFile());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not find attachment ", e);
        }
    }
}

