/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.publish.model;

import com.google.common.collect.Ordering;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class Page
implements Comparable<Page> {
    private String spaceKey;
    private String parentId;
    private String content;
    private Path file;
    private String title;
    private final List<Attachment> attachments = new ArrayList<Attachment>();

    public String getFileName() {
        return this.file.getFileName().toString();
    }

    public void addAttachment(String name, String fileName) {
        Attachment attachment = new Attachment();
        attachment.name = name;
        attachment.file = Paths.get(this.file.getParent().toFile().getAbsolutePath(), fileName);
        this.attachments.add(attachment);
    }

    @Override
    public int compareTo(Page o) {
        return Ordering.from(Comparator.comparing(Page::getFileName)).compare((Object)this, (Object)o);
    }

    public String toString() {
        return "Page{spaceKey='" + this.spaceKey + "', parentId='" + this.parentId + "', title='" + this.title + "', file='" + String.valueOf(this.file) + "'}";
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getContent() {
        return this.content;
    }

    public Path getFile() {
        return this.file;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setFile(Path file) {
        this.file = file;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static class Attachment {
        String name;
        Path file;

        public String getName() {
            return this.name;
        }

        public Path getFile() {
            return this.file;
        }
    }
}

