/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.mapping;

import ch.ifocusit.livingdoc.annotations.UbiquitousLanguage;
import ch.ifocusit.livingdoc.plugin.mapping.DomainObject;
import ch.ifocusit.livingdoc.plugin.utils.AnnotationUtil;
import ch.ifocusit.plantuml.classdiagram.NamesMapper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;

public class GlossaryNamesMapper<A extends UbiquitousLanguage>
implements NamesMapper {
    List<DomainObject> mappings = new ArrayList<DomainObject>();
    private Class<A> annotation;

    public GlossaryNamesMapper(File file, Class<A> annotation) throws IOException {
        this.annotation = annotation;
        if (file != null) {
            this.mappings = CSVFormat.RFC4180.builder().setHeader(new String[]{"id", "name", "description"}).setSkipHeaderRecord(true).build().parse((Reader)new FileReader(file)).stream().map(record -> new DomainObject().setId(Integer.valueOf(record.get("id"))).setName(record.get("name")).setDescription(record.get("description"))).collect(Collectors.toList());
        }
    }

    public List<DomainObject> getMappings() {
        return Collections.unmodifiableList(this.mappings);
    }

    private Optional<String> getName(int id) {
        return this.mappings.stream().filter(def -> def.getId() == id).findFirst().map(DomainObject::getName);
    }

    public String getClassName(Class aClass) {
        int id = AnnotationUtil.tryFind(aClass, this.annotation).map(UbiquitousLanguage::id).orElse(-1);
        return this.getName(id).orElse(super.getClassName(aClass));
    }

    public String getFieldName(Field field) {
        int id = AnnotationUtil.tryFind(field, this.annotation).map(UbiquitousLanguage::id).orElse(-1);
        return this.getName(id).orElse(super.getFieldName(field));
    }
}

