/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.glossary;

import ch.ifocusit.livingdoc.plugin.glossary.JavaElement;
import ch.ifocusit.livingdoc.plugin.glossary.JavaField;
import ch.ifocusit.livingdoc.plugin.mapping.DomainObject;
import ch.ifocusit.livingdoc.plugin.mapping.MappingRespository;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class JavaClass
implements JavaElement,
Comparable<JavaClass> {
    private com.thoughtworks.qdox.model.JavaClass model;
    private Optional<DomainObject> mapping = Optional.empty();
    private List<JavaField> fields;

    public com.thoughtworks.qdox.model.JavaClass getModel() {
        return this.model;
    }

    @Override
    public String getName() {
        return this.mapping.map(DomainObject::getName).orElse(this.model.getName());
    }

    @Override
    public String getDescription() {
        return this.mapping.map(DomainObject::getDescription).orElse(JavaElement.super.getDescription());
    }

    @Override
    public String getType() {
        return this.model.isEnum() ? "Enumeration" : "";
    }

    public List<JavaField> getFields() {
        return this.fields;
    }

    public static JavaClass from(com.thoughtworks.qdox.model.JavaClass javaClass, Predicate<com.thoughtworks.qdox.model.JavaField> fieldPredicate, List<com.thoughtworks.qdox.model.JavaClass> domainClasses, MappingRespository mappingRespository) {
        JavaClass clazz = new JavaClass();
        clazz.model = javaClass;
        clazz.mapping = mappingRespository.getMapping((JavaAnnotatedElement)javaClass);
        clazz.fields = javaClass.getFields().stream().filter(javaField -> !javaField.isStatic()).filter(fieldPredicate).map(javaField -> JavaField.of(javaField, domainClasses, mappingRespository)).collect(Collectors.toList());
        return clazz;
    }

    public boolean hasId() {
        return this.getGlossary().isPresent() || this.fields.stream().anyMatch(javaField -> javaField.getGlossary().isPresent());
    }

    @Override
    public int compareTo(JavaClass o) {
        if (this.hasId() && !o.hasId()) {
            return 1;
        }
        if (!this.hasId() && o.hasId()) {
            return -1;
        }
        if (!this.hasId() && !o.hasId()) {
            return this.getName().compareTo(o.getName());
        }
        return ObjectUtils.compare((Comparable)this.getId(), (Comparable)o.getId(), (boolean)false);
    }
}

