/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin;

import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractAsciidoctorMojo;
import ch.ifocusit.livingdoc.plugin.domain.Publish;
import ch.ifocusit.livingdoc.plugin.publish.HtmlPostProcessor;
import ch.ifocusit.livingdoc.plugin.publish.PublishProvider;
import ch.ifocusit.livingdoc.plugin.publish.confluence.ConfluenceProvider;
import ch.ifocusit.livingdoc.plugin.publish.model.Page;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="publish", defaultPhase=LifecyclePhase.PACKAGE)
public class PublishMojo
extends AbstractAsciidoctorMojo {
    @Parameter(property="livingdoc.publish")
    private final Publish publish = new Publish();

    @Override
    public void executeMojo() throws MojoExecutionException {
        this.extractTemplatesFromJar();
        try {
            ConfluenceProvider provider = new ConfluenceProvider(this.publish.getEndpoint(), this.publish.getUsername(), this.publish.getPassword());
            List<Page> pages = this.readHtmlPages();
            this.publish(provider, pages);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unexpected error", e);
        }
    }

    private List<Page> readHtmlPages() throws IOException {
        ArrayList<Page> pages = new ArrayList<Page>();
        try (Stream<Path> paths = Files.walk(Paths.get(this.generatedDocsDirectory.getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
            paths.filter(path -> FilenameUtils.isExtension((String)path.getFileName().toString(), (String[])new String[]{AbstractAsciidoctorMojo.Format.adoc.name(), AbstractAsciidoctorMojo.Format.asciidoc.name(), AbstractAsciidoctorMojo.Format.html.name()})).forEach(path -> {
                try {
                    this.getLog().info((CharSequence)("Publish goal - process " + String.valueOf(path)));
                    HashMap<String, String> attachmentCollector = new HashMap<String, String>();
                    HtmlPostProcessor htmlProcessor = this.getPostProcessor();
                    Page page = new Page();
                    page.setSpaceKey(this.publish.getSpaceKey());
                    page.setParentId(this.publish.getAncestorId());
                    page.setTitle(htmlProcessor.getPageTitle((Path)path));
                    page.setFile((Path)path);
                    String content = htmlProcessor.process((Path)path, (Map<String, String>)attachmentCollector);
                    page.setContent(content);
                    attachmentCollector.forEach(page::addAttachment);
                    pages.add(page);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("error reading file", e);
                }
            });
        }
        return pages;
    }

    private HtmlPostProcessor getPostProcessor() {
        return new HtmlPostProcessor(this.createAsciidoctor(), this.options());
    }

    private void publish(PublishProvider provider, List<Page> pages) {
        pages.stream().sorted().forEach(page -> {
            if (provider.exists((Page)page)) {
                this.getLog().info((CharSequence)("Publish goal - update " + String.valueOf(page)));
                provider.update((Page)page);
            } else {
                this.getLog().info((CharSequence)("Publish goal - insert " + String.valueOf(page)));
                provider.insert((Page)page);
            }
        });
    }
}

