/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.gherkin;

import ch.ifocusit.livingdoc.plugin.utils.AsciidocUtil;
import com.github.domgold.doctools.asciidoctor.gherkin.MapFormatter;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GherkinToAsciidocTransformer {
    private final StringBuilder builder = new StringBuilder();

    public String transform(String fileContent) {
        return this.format(MapFormatter.parse((String)fileContent));
    }

    private String format(Map<String, Object> parsed) {
        this.builder.append("=== ").append(parsed.get("name")).append(AsciidocUtil.NEWLINE).append(AsciidocUtil.NEWLINE);
        this.manageDescription(parsed);
        if (parsed.containsKey("background")) {
            Map background = (Map)parsed.get("background");
            this.manageScenario(background);
        }
        if (parsed.containsKey("scenarios")) {
            List scenarios = (List)parsed.get("scenarios");
            for (Map scenario : scenarios) {
                this.manageScenario(scenario);
            }
        }
        return this.builder.toString();
    }

    private void manageDescription(Map<String, Object> container) {
        String description = (String)container.get("description");
        if (StringUtils.isNotBlank((CharSequence)description)) {
            this.builder.append(description).append(AsciidocUtil.NEWLINE);
        }
        this.builder.append(AsciidocUtil.NEWLINE);
    }

    private void manageScenario(Map<String, Object> scenario) {
        this.builder.append("==== ").append(scenario.get("name")).append(AsciidocUtil.NEWLINE);
        this.manageDescription(scenario);
        this.manageSteps(scenario);
        this.manageTable(scenario);
    }

    private void manageSteps(Map<String, Object> container) {
        if (container.containsKey("steps")) {
            List steps = (List)container.get("steps");
            for (Map step : steps) {
                String keyword = (String)step.get("keyword");
                this.builder.append("* *").append(keyword.trim()).append("* ").append(step.get("name")).append(AsciidocUtil.NEWLINE);
                if (step.containsKey("doc_string")) {
                    Map doc_string = (Map)step.get("doc_string");
                    this.builder.append("+").append(AsciidocUtil.NEWLINE).append("....").append(AsciidocUtil.NEWLINE).append(doc_string.get("value")).append("....").append(AsciidocUtil.NEWLINE);
                }
                this.builder.append(AsciidocUtil.NEWLINE);
                this.manageTable(step);
            }
        }
    }

    private void manageTable(Map<String, Object> container) {
        if (container.containsKey("examples")) {
            Map examples = (Map)container.get("examples");
            this.builder.append("===== ").append(examples.get("keyword")).append(AsciidocUtil.NEWLINE);
            List rows = (List)examples.get("rows");
            this.builder.append("|====").append(AsciidocUtil.NEWLINE);
            for (Map row : rows) {
                List cells = (List)row.get("cells");
                for (Object cell : cells) {
                    this.builder.append("| ").append(cell);
                }
                this.builder.append(AsciidocUtil.NEWLINE);
            }
            this.builder.append("|====").append(AsciidocUtil.NEWLINE).append(AsciidocUtil.NEWLINE);
        }
    }
}

