/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.mapping;

import ch.ifocusit.livingdoc.plugin.utils.AsciidocUtil;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DomainObject
implements Comparable<DomainObject> {
    private Integer id;
    private String namespace;
    private String parentName;
    private String name;
    private String description;
    private JavaClass type;
    private List<String> annotations = new ArrayList<String>();
    private boolean mapped = false;

    public Integer getId() {
        return this.id;
    }

    public DomainObject setId(Integer id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DomainObject setName(String name) {
        this.name = name;
        return this;
    }

    public String getAnnotations() {
        return this.annotations.stream().collect(Collectors.joining(AsciidocUtil.NEWLINE + AsciidocUtil.NEWLINE));
    }

    public String getFullDescription() {
        return this.getAnnotations() + (String)(this.annotations.isEmpty() ? "" : AsciidocUtil.NEWLINE + AsciidocUtil.NEWLINE) + this.getDescription();
    }

    public DomainObject setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return Optional.ofNullable(this.description).orElse("");
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setMapped(boolean mapped) {
        this.mapped = mapped;
    }

    public void addAnnotation(String annotation) {
        this.annotations.add(annotation);
    }

    public void setType(JavaClass type) {
        this.type = type;
    }

    public JavaClass getType() {
        return this.type;
    }

    public String getFullName() {
        return (String)(!this.mapped && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.parentName}) ? this.parentName + "." : "") + this.name;
    }

    @Override
    public int compareTo(DomainObject o) {
        return new Ordering<DomainObject>(){

            public int compare(DomainObject left, DomainObject right) {
                return ComparisonChain.start().compare((Object)left.id, (Object)right.id, (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.name, (Object)right.name, (Comparator)Ordering.natural().nullsFirst()).compare((Object)left.description, (Object)right.description, (Comparator)Ordering.natural().nullsFirst()).result();
            }
        }.nullsFirst().compare((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }
}

