/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.publish.confluence;

import ch.ifocusit.livingdoc.plugin.publish.PublishProvider;
import ch.ifocusit.livingdoc.plugin.publish.confluence.client.ConfluencePage;
import ch.ifocusit.livingdoc.plugin.publish.confluence.client.ConfluenceRestClient;
import ch.ifocusit.livingdoc.plugin.publish.confluence.client.NotFoundException;
import ch.ifocusit.livingdoc.plugin.publish.model.Page;
import ch.ifocusit.livingdoc.plugin.utils.InputStreamUtils;

public class ConfluenceProvider
implements PublishProvider {
    final ConfluenceRestClient client;

    public ConfluenceProvider(String endpoint, String username, String password) {
        this.client = new ConfluenceRestClient(endpoint, username, password);
    }

    @Override
    public boolean exists(Page page) {
        try {
            this.client.getPageByTitle(page.getSpaceKey(), page.getTitle());
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    @Override
    public void update(Page page) {
        String contentId = this.client.getPageByTitle(page.getSpaceKey(), page.getTitle());
        ConfluencePage existingPage = this.client.getPageWithContentAndVersionById(contentId);
        String oldContent = existingPage.getContent();
        if (!oldContent.equals(page.getContent())) {
            this.client.updatePage(contentId, page.getParentId(), page.getTitle(), page.getContent(), existingPage.getVersion() + 1);
            this.client.getAttachments(contentId).forEach(attachment -> this.client.deleteAttachment(attachment.getId()));
            page.getAttachments().forEach(attachement -> this.client.addAttachment(contentId, attachement.getName(), InputStreamUtils.fileInputStream(attachement.getFile())));
        } else {
            System.out.println("Page with title=" + page.getTitle() + " did not change.");
        }
    }

    @Override
    public void insert(Page page) {
        String contentId = this.client.addPageUnderAncestor(page.getSpaceKey(), page.getParentId(), page.getTitle(), page.getContent());
        page.getAttachments().forEach(attachement -> this.client.addAttachment(contentId, attachement.getName(), InputStreamUtils.fileInputStream(attachement.getFile())));
    }
}

