/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.diagram;

import ch.ifocusit.livingdoc.annotations.UbiquitousLanguage;
import ch.ifocusit.livingdoc.plugin.mapping.GlossaryNamesMapper;
import ch.ifocusit.livingdoc.plugin.utils.AnchorUtil;
import ch.ifocusit.livingdoc.plugin.utils.AnnotationUtil;
import ch.ifocusit.livingdoc.plugin.utils.ClassLoaderUtil;
import ch.ifocusit.livingdoc.plugin.utils.FileUtils;
import ch.ifocusit.livingdoc.plugin.utils.StringUtil;
import ch.ifocusit.plantuml.classdiagram.LinkMaker;
import ch.ifocusit.plantuml.classdiagram.NamesMapper;
import ch.ifocusit.plantuml.classdiagram.model.Link;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractClassDiagramBuilder
implements LinkMaker,
NamesMapper {
    private static final String TEST = "Test";
    private static final String IT = "IT";
    private static final String PACKAGE_INFO = "package-info";
    protected MavenProject project;
    protected String prefix;
    protected String[] excludes;
    protected String header;
    protected String footer;
    protected File startOptions;
    protected File endOptions;
    protected boolean diagramWithDependencies;
    protected String linkPage;
    protected String diagramTitle;
    private boolean diagramWithLink;
    protected NamesMapper namesMapper = this;

    public abstract void filterOnAnnotation(Class<? extends Annotation> var1);

    public abstract String build() throws MojoExecutionException;

    protected String[] readStartOptions() throws MojoExecutionException {
        return FileUtils.read(this.startOptions);
    }

    protected String[] readEndOptions() throws MojoExecutionException {
        return FileUtils.read(this.endOptions);
    }

    protected Predicate<ClassPath.ClassInfo> defaultFilter() {
        return ci -> ci.getPackageName().startsWith(this.prefix) && !ci.getSimpleName().equalsIgnoreCase(PACKAGE_INFO) && !ci.getSimpleName().endsWith(TEST) && !ci.getSimpleName().endsWith(IT) && Arrays.stream(this.excludes).noneMatch(excl -> ci.getName().matches((String)excl));
    }

    protected ClassPath initClassPath() throws MojoExecutionException {
        try {
            return ClassPath.from((ClassLoader)ClassLoaderUtil.getRuntimeClassLoader(this.project));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to initialize classPath !", (Exception)e);
        }
    }

    public void mapNames(File mappings) throws MojoExecutionException {
        try {
            this.namesMapper = new GlossaryNamesMapper<UbiquitousLanguage>(mappings, UbiquitousLanguage.class);
        }
        catch (IOException e) {
            throw new MojoExecutionException("error reading mappings file", (Exception)e);
        }
    }

    private Optional<Link> createLink(Integer linkId, String defaultLinkId) {
        Link link = new Link();
        link.setUrl(AnchorUtil.formatLinkWithPage(this.linkPage, linkId, defaultLinkId));
        link.setTooltip(StringUtil.defaultString(linkId, defaultLinkId));
        return Optional.of(link);
    }

    public Optional<Link> getClassLink(Class aClass) {
        if (!this.diagramWithLink) {
            return Optional.empty();
        }
        Integer id = AnnotationUtil.tryFind(aClass, UbiquitousLanguage.class).map(UbiquitousLanguage::id).orElse(null);
        String label = this.namesMapper.getClassName(aClass);
        return this.createLink(id, label);
    }

    public Optional<Link> getFieldLink(Field field) {
        if (!this.diagramWithLink) {
            return Optional.empty();
        }
        String parentLabel = this.namesMapper.getClassName(field.getDeclaringClass());
        String label = this.namesMapper.getFieldName(field);
        Integer id = AnnotationUtil.tryFind(field, UbiquitousLanguage.class).map(UbiquitousLanguage::id).orElse(null);
        String defaultLinkId = AnchorUtil.glossaryLink(parentLabel, label);
        return this.createLink(id, defaultLinkId);
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public void setStartOptions(File startOptions) {
        this.startOptions = startOptions;
    }

    public void setEndOptions(File endOptions) {
        this.endOptions = endOptions;
    }

    public void setDiagramWithDependencies(boolean diagramWithDependencies) {
        this.diagramWithDependencies = diagramWithDependencies;
    }

    public void setLinkPage(String linkPage) {
        this.linkPage = linkPage;
    }

    public void setDiagramTitle(String diagramTitle) {
        this.diagramTitle = diagramTitle;
    }

    public void setDiagramWithLink(boolean diagramWithLink) {
        this.diagramWithLink = diagramWithLink;
    }

    public void setNamesMapper(NamesMapper namesMapper) {
        this.namesMapper = namesMapper;
    }
}

