/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin;

import ch.ifocusit.livingdoc.annotations.UbiquitousLanguage;
import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractAsciidoctorMojo;
import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractDocsGeneratorMojo;
import ch.ifocusit.livingdoc.plugin.diagram.PlantumlClassDiagramBuilder;
import ch.ifocusit.livingdoc.plugin.domain.Cluster;
import ch.ifocusit.livingdoc.plugin.domain.Color;
import io.github.robwin.markup.builder.asciidoc.AsciiDocBuilder;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="diagram", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class DiagramMojo
extends AbstractDocsGeneratorMojo {
    private static final Color DEFAULT_ROOT_COLOR = Color.from("wheat", null);
    @Parameter
    private String[] excludes = new String[0];
    @Parameter(property="livingdoc.diagram.type", defaultValue="plantuml")
    private DiagramType diagramType;
    @Parameter(property="livingdoc.diagram.image.format", defaultValue="png")
    private DiagramImageType diagramImageType;
    @Parameter(property="livingdoc.diagram.link.activate", defaultValue="false")
    private boolean diagramWithLink = true;
    @Parameter(property="livingdoc.diagram.link.page", defaultValue="glossary.html")
    private String diagramLinkPage;
    @Parameter(property="livingdoc.diagram.rootAggregate.class")
    private String rootAggregateClassMatcher;
    @Parameter(property="livingdoc.diagram.rootAggregate.color")
    private Color rootAggregateColor;
    @Parameter(property="livingdoc.diagram.cluster.detect", defaultValue="true")
    private boolean detectCluster;
    @Parameter
    private List<Cluster> clusters;
    @Parameter(property="livingdoc.diagram.methods.show", defaultValue="true")
    private boolean diagramShowMethods;
    @Parameter(property="livingdoc.diagram.fields.show", defaultValue="true")
    private boolean diagramShowFields;
    @Parameter(property="livingdoc.diagram.start-options", defaultValue="${project.basedir}/src/main/livingdoc/diagram-start.options")
    private File diagramStartOptions;
    @Parameter(property="livingdoc.diagram.end-options", defaultValue="${project.basedir}/src/main/livingdoc/diagram-end.options")
    private File diagramEndOptions;
    @Parameter(property="livingdoc.diagram.header")
    private String diagramHeader;
    @Parameter(property="livingdoc.diagram.footer")
    private String diagramFooter;
    @Parameter(property="livingdoc.diagram.interactive", defaultValue="false")
    private boolean interactive;
    @Parameter(property="livingdoc.diagram.as-include-file", defaultValue="false")
    private boolean asIncludeFile;
    @Parameter(property="livingdoc.diagram.as-plantuml-macro", defaultValue="false")
    private boolean diagramAsPlantumlMacro;
    @Parameter(property="livingdoc.diagram.output.filename", defaultValue="diagram")
    private String diagramOutputFilename;
    @Parameter(property="livingdoc.diagram.title")
    private String diagramTitle;
    @Parameter(property="livingdoc.diagram.withDeps")
    private Boolean diagramWithDependencies;
    @Parameter(property="livingdoc.diagram.useExternalGraphviz", defaultValue="false")
    private boolean diagramUseExternalGraphviz;
    @Parameter(property="livingdoc.diagram.singleClassAndDependencies")
    protected String singleClassAndDependencies;

    @Override
    protected String getOutputFilename() {
        return this.diagramOutputFilename;
    }

    @Override
    protected String getTitle() {
        return this.diagramTitle;
    }

    @Override
    public void executeMojo() throws MojoExecutionException {
        String diagram;
        if (this.interactive) {
            this.diagramWithLink = true;
            this.diagramImageType = DiagramImageType.svg;
        }
        if (StringUtils.isNotBlank((CharSequence)this.diagramLinkPage)) {
            this.diagramWithLink = true;
        }
        if (StringUtils.isBlank((CharSequence)(diagram = this.generateDiagram()))) {
            return;
        }
        switch (this.format) {
            case html: 
            case adoc: 
            case asciidoc: {
                AsciiDocBuilder asciiDocBuilder = this.createAsciiDocBuilder();
                this.appendTitle(asciiDocBuilder);
                if (this.diagramAsPlantumlMacro) {
                    this.write(diagram, this.getOutput(this.getOutputFilename(), AbstractAsciidoctorMojo.Format.plantuml));
                    asciiDocBuilder.textLine("plantuml::" + this.getOutputFilename() + ".plantuml[]");
                } else {
                    if (Objects.requireNonNull(this.diagramType) == DiagramType.plantuml) {
                        asciiDocBuilder.textLine(String.format("[plantuml, target=%s, format=%s" + (this.interactive ? ", opts=interactive" : "") + "]", new Object[]{this.getOutputFilename(), this.diagramImageType}));
                    }
                    asciiDocBuilder.textLine("----");
                    if (this.asIncludeFile) {
                        this.write(diagram, this.getOutput(this.getOutputFilename(), AbstractAsciidoctorMojo.Format.plantuml));
                        asciiDocBuilder.textLine("include::" + this.getOutputFilename() + ".plantuml[]");
                    } else {
                        asciiDocBuilder.textLine(diagram);
                    }
                    asciiDocBuilder.textLine("----");
                }
                this.write(asciiDocBuilder);
                break;
            }
            case plantuml: {
                this.write(diagram, this.getOutput(this.getOutputFilename(), AbstractAsciidoctorMojo.Format.plantuml));
            }
        }
    }

    String generateDiagram() throws MojoExecutionException {
        this.getLog().info((CharSequence)("generate diagram with packageRoot=" + this.packageRoot));
        if (this.diagramType == DiagramType.plantuml) {
            PlantumlClassDiagramBuilder builder = new PlantumlClassDiagramBuilder();
            builder.setProject(this.project);
            builder.setPrefix(StringUtils.isNotBlank((CharSequence)this.singleClassAndDependencies) ? "" : this.packageRoot);
            builder.setSingleClass(this.singleClassAndDependencies);
            builder.setDiagramWithLink(this.diagramWithLink);
            builder.setExcludes((String[])Stream.of(this.excludes).map(s -> s.replaceAll("\n", "").replaceAll("\r", "").replaceAll(" ", "")).toArray(String[]::new));
            builder.setRootAggregateClassMatcher(this.rootAggregateClassMatcher);
            builder.setRootAggregateColor(this.rootAggregateColor == null || this.rootAggregateColor.isEmpty() ? DEFAULT_ROOT_COLOR : this.rootAggregateColor);
            builder.setHeader(this.diagramHeader);
            builder.setStartOptions(this.diagramStartOptions);
            builder.setEndOptions(this.diagramEndOptions);
            builder.setFooter(this.diagramFooter);
            builder.setShowMethods(this.diagramShowMethods);
            builder.setShowFields(this.diagramShowFields);
            builder.setDiagramWithDependencies(this.diagramWithDependencies == null ? StringUtils.isNotBlank((CharSequence)this.singleClassAndDependencies) : this.diagramWithDependencies);
            builder.setLinkPage(this.diagramLinkPage);
            builder.setDiagramTitle(this.diagramTitle);
            if (this.onlyAnnotated) {
                builder.filterOnAnnotation(UbiquitousLanguage.class);
            }
            if (this.diagramWithLink && !DiagramImageType.png.equals((Object)this.diagramImageType)) {
                builder.mapNames(this.glossaryMapping);
            }
            builder.setUseExternalGraphiz(this.diagramUseExternalGraphviz);
            return builder.build();
        }
        throw new NotImplementedException(String.format("format %s is not implemented yet", new Object[]{this.diagramType}));
    }

    public DiagramMojo setDiagramTitle(String diagramTitle) {
        this.diagramTitle = diagramTitle;
        return this;
    }

    public DiagramMojo setDiagramType(DiagramType diagramType) {
        this.diagramType = diagramType;
        return this;
    }

    public static enum DiagramImageType {
        png,
        svg,
        txt;

    }

    public static enum DiagramType {
        plantuml;

    }
}

