/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.glossary;

import ch.ifocusit.livingdoc.plugin.glossary.JavaElement;
import ch.ifocusit.livingdoc.plugin.mapping.DomainObject;
import ch.ifocusit.livingdoc.plugin.mapping.MappingRespository;
import ch.ifocusit.livingdoc.plugin.utils.AnchorUtil;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.List;
import java.util.Optional;

public class JavaField
implements JavaElement {
    private com.thoughtworks.qdox.model.JavaField model;
    private Optional<DomainObject> mapping = Optional.empty();
    private boolean partOfDomain = false;

    @Override
    public String getName() {
        return this.mapping.map(DomainObject::getName).orElse(this.model.getName());
    }

    @Override
    public String getDescription() {
        return this.mapping.map(DomainObject::getDescription).orElse(JavaElement.super.getDescription());
    }

    public String getFullName() {
        return AnchorUtil.glossaryLink(this.model.getDeclaringClass().getName(), this.getName());
    }

    public String getLinkableFullName() {
        return this.getAnchor() + this.getFullName();
    }

    @Override
    public String getType() {
        if (this.model.isEnumConstant()) {
            return "";
        }
        Object typeName = this.model.getType().getName();
        if (this.model.getType().isEnum()) {
            typeName = (String)typeName + ", Enumeration";
        }
        return typeName;
    }

    @Override
    public JavaAnnotatedElement getModel() {
        return this.model;
    }

    public boolean isPartOfDomain() {
        return this.partOfDomain;
    }

    public String getLinkedType() {
        if (this.model.isEnumConstant()) {
            return "";
        }
        Object name = this.model.getType().getName();
        if (this.isPartOfDomain()) {
            name = "<<" + AnchorUtil.formatLink(this.getGlossaryId((JavaAnnotatedElement)this.model.getType()).orElse(null), this.model.getType().getName()) + "," + this.model.getType().getName() + ">>";
        }
        if (this.model.getType().isEnum()) {
            name = (String)name + ", Enumeration";
        }
        return name;
    }

    @Override
    public String getAnchor() {
        return "anchor:" + AnchorUtil.formatLink(this.getGlossaryId().orElse(null), this.getFullName()) + "[]";
    }

    public static JavaField of(com.thoughtworks.qdox.model.JavaField javaField, List<JavaClass> domainClasses, MappingRespository mappingRespository) {
        JavaField field = new JavaField();
        field.model = javaField;
        field.mapping = mappingRespository.getMapping((JavaAnnotatedElement)javaField);
        field.partOfDomain = domainClasses.stream().anyMatch(arg_0 -> ((JavaClass)javaField.getType()).equals(arg_0));
        return field;
    }
}

