/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.diagram;

import ch.ifocusit.livingdoc.annotations.RootAggregate;
import ch.ifocusit.livingdoc.plugin.diagram.AbstractClassDiagramBuilder;
import ch.ifocusit.livingdoc.plugin.domain.Color;
import ch.ifocusit.livingdoc.plugin.utils.AnnotationUtil;
import ch.ifocusit.livingdoc.plugin.utils.AsciidocUtil;
import ch.ifocusit.plantuml.classdiagram.ClassDiagramBuilder;
import ch.ifocusit.plantuml.classdiagram.LinkMaker;
import ch.ifocusit.plantuml.classdiagram.model.attribute.ClassAttribute;
import ch.ifocusit.plantuml.classdiagram.model.clazz.JavaClazz;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlantumlClassDiagramBuilder
extends AbstractClassDiagramBuilder {
    private static final String PRAGMA_LAYOUT_SMETANA = "!pragma layout smetana";
    Logger LOG = LoggerFactory.getLogger(PlantumlClassDiagramBuilder.class);
    private ClassDiagramBuilder classDiagramBuilder;
    private Predicate<ClassPath.ClassInfo> additionalClassPredicate = a -> true;
    private Predicate<ClassAttribute> fieldPredicate = null;
    private boolean showMethods;
    private boolean showFields;
    private boolean useExternalGraphviz = false;
    private String rootAggregateClassMatcher;
    private Color rootAggregateColor;

    @Override
    public String build() throws MojoExecutionException {
        this.classDiagramBuilder = new ClassDiagramBuilder(){

            public JavaClazz createJavaClass(Class clazz) {
                JavaClazz javaClass = super.createJavaClass(clazz);
                if (PlantumlClassDiagramBuilder.this.rootAggregateColor != null) {
                    if (StringUtils.isNotBlank((CharSequence)PlantumlClassDiagramBuilder.this.rootAggregateClassMatcher)) {
                        if (clazz.getName().matches(PlantumlClassDiagramBuilder.this.rootAggregateClassMatcher)) {
                            javaClass.setBackgroundColor(PlantumlClassDiagramBuilder.this.rootAggregateColor.getBackground()).setBorderColor(PlantumlClassDiagramBuilder.this.rootAggregateColor.getBorder());
                        }
                    } else {
                        AnnotationUtil.tryFind(clazz, RootAggregate.class).ifPresent(annot -> javaClass.setBackgroundColor(PlantumlClassDiagramBuilder.this.rootAggregateColor.getBackground()).setBorderColor(PlantumlClassDiagramBuilder.this.rootAggregateColor.getBorder()));
                    }
                }
                return javaClass;
            }
        };
        if (this.fieldPredicate != null) {
            this.classDiagramBuilder.addFieldPredicate(this.fieldPredicate);
        }
        ClassPath classPath = this.initClassPath();
        ImmutableSet allClasses = classPath.getTopLevelClassesRecursive(this.prefix);
        List classes = allClasses.stream().filter(this.defaultFilter()).filter(this.additionalClassPredicate).map(classInfo -> {
            try {
                return classInfo.load();
            }
            catch (Throwable e) {
                this.LOG.warn(e.toString());
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)this.singleClass)) {
            try {
                classes.add(this.getClassLoader().loadClass(this.singleClass));
            }
            catch (ClassNotFoundException e) {
                this.LOG.error("Class '" + this.singleClass + "' not found! Will be ignored.");
            }
        }
        this.LOG.info("Initial classes size: " + classes.size());
        Object[] startOptions = this.readStartOptions();
        if (!this.useExternalGraphviz) {
            startOptions = (String[])ArrayUtils.add((Object[])startOptions, (Object)(PRAGMA_LAYOUT_SMETANA + AsciidocUtil.NEWLINE));
        }
        return this.classDiagramBuilder.addClasses(classes).withNamesMapper(this.namesMapper).excludes(this.excludes).setStartOptions((String[])startOptions).setTitle(this.diagramTitle).setHeader(this.header).setFooter(this.footer).setEndOptions(this.readEndOptions()).withLinkMaker((LinkMaker)this).withDependencies(this.diagramWithDependencies).build();
    }

    @Override
    protected String[] readStartOptions() throws MojoExecutionException {
        Object[] headers = super.readStartOptions();
        if (!this.showFields) {
            headers = (String[])ArrayUtils.add((Object[])headers, (Object)("hide fields" + AsciidocUtil.NEWLINE));
        }
        if (!this.showMethods) {
            headers = (String[])ArrayUtils.add((Object[])headers, (Object)("hide methods" + AsciidocUtil.NEWLINE));
        }
        return headers;
    }

    @Override
    public void filterOnAnnotation(Class<? extends Annotation> annotation) {
        if (annotation == null) {
            return;
        }
        this.additionalClassPredicate = this.additionalClassPredicate.and(classInfo -> classInfo.load().isAnnotationPresent(annotation));
        this.fieldPredicate = attribut -> attribut.getField().isAnnotationPresent(annotation);
    }

    public void setUseExternalGraphiz(boolean useExternalGraphviz) {
        this.useExternalGraphviz = useExternalGraphviz;
    }

    public void setLOG(Logger LOG) {
        this.LOG = LOG;
    }

    public void setClassDiagramBuilder(ClassDiagramBuilder classDiagramBuilder) {
        this.classDiagramBuilder = classDiagramBuilder;
    }

    public void setAdditionalClassPredicate(Predicate<ClassPath.ClassInfo> additionalClassPredicate) {
        this.additionalClassPredicate = additionalClassPredicate;
    }

    public void setFieldPredicate(Predicate<ClassAttribute> fieldPredicate) {
        this.fieldPredicate = fieldPredicate;
    }

    public void setShowMethods(boolean showMethods) {
        this.showMethods = showMethods;
    }

    public void setShowFields(boolean showFields) {
        this.showFields = showFields;
    }

    public void setUseExternalGraphviz(boolean useExternalGraphviz) {
        this.useExternalGraphviz = useExternalGraphviz;
    }

    public void setRootAggregateClassMatcher(String rootAggregateClassMatcher) {
        this.rootAggregateClassMatcher = rootAggregateClassMatcher;
    }

    public void setRootAggregateColor(Color rootAggregateColor) {
        this.rootAggregateColor = rootAggregateColor;
    }
}

