/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.baseMojo;

import ch.ifocusit.livingdoc.plugin.publish.confluence.PlantumlMacroBlockProcessor;
import io.github.robwin.markup.builder.asciidoc.AsciiDocBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.SafeMode;
import org.asciidoctor.extension.JavaExtensionRegistry;
import org.asciidoctor.extension.RubyExtensionRegistry;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public abstract class AbstractAsciidoctorMojo
extends AbstractMojo {
    protected static final String TEMPLATES_OUTPUT = "${project.build.directory}/asciidoc-templates";
    private static final String TEMPLATES_CLASSPATH_PATTERN = "templates/*";
    protected static final String PLANTUML_MACRO_NAME = "plantuml";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="livingdoc.output.directory", defaultValue="${project.build.directory}/generated-docs", required=true)
    protected File generatedDocsDirectory;
    @Parameter(property="livingdoc.asciidocTemplate", defaultValue="${project.build.directory}/asciidoc-templates", readonly=true)
    private File asciidocTemplates;
    @Parameter(property="livingdoc.newlineCharacter", defaultValue="\r\n", readonly=true)
    private String newlineCharacter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        System.setProperty("line.separator", "\r\n");
        if (StringUtils.isNotBlank((CharSequence)this.newlineCharacter)) {
            System.setProperty("line.separator", this.newlineCharacter);
        }
        this.executeMojo();
    }

    public abstract void executeMojo() throws MojoExecutionException, MojoFailureException;

    protected void write(AsciiDocBuilder asciiDocBuilder, Format format, String outputFilename) throws MojoExecutionException {
        this.generatedDocsDirectory.mkdirs();
        File output = this.getOutput(outputFilename, Format.adoc);
        try {
            asciiDocBuilder.writeToFile(this.generatedDocsDirectory.getAbsolutePath(), FilenameUtils.removeExtension((String)outputFilename), StandardCharsets.UTF_8);
            if (Format.html.equals((Object)format)) {
                this.createAsciidoctor().convertFile(output, this.options());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Unable to convert asciidoc file '%s' to html !", output.getAbsolutePath()), (Exception)e);
        }
    }

    protected File getOutput(String filename, Format desiredExtension) {
        filename = FilenameUtils.isExtension((String)filename, (String)desiredExtension.name()) ? filename : filename + "." + String.valueOf((Object)desiredExtension);
        return new File(this.generatedDocsDirectory, filename);
    }

    public Asciidoctor createAsciidoctor() {
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        asciidoctor.requireLibrary(new String[]{"asciidoctor-diagram"});
        JavaExtensionRegistry extensionRegistry = asciidoctor.javaExtensionRegistry();
        extensionRegistry.blockMacro(PLANTUML_MACRO_NAME, PlantumlMacroBlockProcessor.class);
        RubyExtensionRegistry rubyExtensionRegistry = asciidoctor.rubyExtensionRegistry();
        rubyExtensionRegistry.loadClass(((Object)((Object)this)).getClass().getResourceAsStream("/com/github/domgold/doctools/asciidoctor/gherkin/gherkinblockmacro.rb")).blockMacro("gherkin", "GherkinBlockMacroProcessor");
        return asciidoctor;
    }

    protected Options options() {
        this.asciidocTemplates.mkdirs();
        String imagesOutputDirectory = this.generatedDocsDirectory.getAbsolutePath();
        return Options.builder().backend("html5").safe(SafeMode.UNSAFE).baseDir(this.generatedDocsDirectory).templateDirs(new File[]{this.asciidocTemplates}).attributes(Attributes.builder().attribute("imagesoutdir", (Object)imagesOutputDirectory).attribute("outdir", (Object)imagesOutputDirectory).build()).build();
    }

    protected void extractTemplatesFromJar() {
        this.asciidocTemplates.mkdirs();
        try {
            Arrays.asList(new PathMatchingResourcePatternResolver().getResources(TEMPLATES_CLASSPATH_PATTERN)).forEach(templateResource -> {
                try {
                    FileUtils.copyInputStreamToFile((InputStream)templateResource.getInputStream(), (File)new File(this.asciidocTemplates, Objects.requireNonNull(templateResource.getFilename())));
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not write template to target file", e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Format {
        asciidoc,
        adoc,
        html,
        plantuml;

    }
}

