/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.gherkin;

import com.github.domgold.doctools.asciidoctor.gherkin.MapFormatter;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.jruby.embed.ScriptingContainer;

public class StandaloneGherkinProcessor {
    private File gherkinTemplate;

    public String process(String fileContent) {
        ScriptingContainer container = new ScriptingContainer();
        container.put("feature_file_content", (Object)fileContent);
        container.put("template_content", (Object)(this.gherkinTemplate != null ? IOUtils.toString((URI)this.gherkinTemplate.toURI(), (Charset)Charset.defaultCharset()) : MapFormatter.getDefaultTemplate()));
        String scriptPath = "/standaloneGherkinProcessor.rb";
        String script = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream(scriptPath)), (Charset)Charset.defaultCharset());
        return (String)container.runScriptlet(script);
    }

    StandaloneGherkinProcessor(File gherkinTemplate) {
        this.gherkinTemplate = gherkinTemplate;
    }

    public static StandaloneGherkinProcessorBuilder builder() {
        return new StandaloneGherkinProcessorBuilder();
    }

    public static class StandaloneGherkinProcessorBuilder {
        private File gherkinTemplate;

        StandaloneGherkinProcessorBuilder() {
        }

        public StandaloneGherkinProcessorBuilder gherkinTemplate(File gherkinTemplate) {
            this.gherkinTemplate = gherkinTemplate;
            return this;
        }

        public StandaloneGherkinProcessor build() {
            return new StandaloneGherkinProcessor(this.gherkinTemplate);
        }

        public String toString() {
            return "StandaloneGherkinProcessor.StandaloneGherkinProcessorBuilder(gherkinTemplate=" + String.valueOf(this.gherkinTemplate) + ")";
        }
    }
}

