/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.publish;

import ch.ifocusit.livingdoc.plugin.utils.AsciidocUtil;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;

public class HtmlPostProcessor {
    private static final Pattern CDATA_PATTERN = Pattern.compile("<!\\[CDATA\\[.*?]]>", 32);
    private static final Pattern ATTACHMENT_PATH_PATTERN = Pattern.compile("<ri:attachment ri:filename=\"(.*?)\"");
    private static final Pattern PAGE_TITLE_PATTERN = Pattern.compile("<ri:page ri:content-title=\"(.*?)\"");
    private final Asciidoctor asciidoctor;
    private final Options options;

    public HtmlPostProcessor(Asciidoctor asciidoctor, Options options) {
        this.asciidoctor = asciidoctor;
        this.options = options;
    }

    public String process(Path path, Map<String, String> attachmentCollector) throws IOException {
        String initialContent;
        String processedContent = initialContent = FileUtils.readFileToString((File)path.toFile(), (Charset)Charset.defaultCharset());
        if (AsciidocUtil.isAdoc(path)) {
            processedContent = this.asciidoctor.convert(initialContent, this.options);
        }
        return this.postProcessContent(processedContent, this.replaceCrossReferenceTargets(path), this.collectAndReplaceAttachmentFileNames(attachmentCollector), this.unescapeCdataHtmlContent());
    }

    private Function<String, String> unescapeCdataHtmlContent() {
        return content -> this.replaceAll((String)content, CDATA_PATTERN, matchResult -> StringEscapeUtils.unescapeHtml4((String)matchResult.group()));
    }

    private String deriveAttachmentName(String path) {
        return path.contains("/") ? path.substring(path.lastIndexOf(47) + 1) : path;
    }

    private Function<String, String> collectAndReplaceAttachmentFileNames(Map<String, String> attachmentCollector) {
        return content -> this.replaceAll((String)content, ATTACHMENT_PATH_PATTERN, matchResult -> {
            String attachmentPath = matchResult.group(1);
            String attachmentFileName = this.deriveAttachmentName(attachmentPath);
            attachmentCollector.put(attachmentPath, attachmentFileName);
            return "<ri:attachment ri:filename=\"" + attachmentFileName + "\"";
        });
    }

    private String replaceAll(String content, Pattern pattern, Function<MatchResult, String> replacer) {
        StringBuilder replacedContent = new StringBuilder();
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            matcher.appendReplacement(replacedContent, replacer.apply(matcher.toMatchResult()));
        }
        matcher.appendTail(replacedContent);
        return replacedContent.toString();
    }

    @SafeVarargs
    private String postProcessContent(String initialContent, Function<String, String> ... postProcessors) {
        return Arrays.stream(postProcessors).reduce(initialContent, (accumulator, postProcessor) -> (String)postProcessor.apply(accumulator), this.unusedCombiner());
    }

    public String getPageTitle(Path path) {
        String pageContent;
        try {
            pageContent = IOUtils.toString((InputStream)new FileInputStream(path.toFile()), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read page title !", e);
        }
        try {
            String title = "";
            title = AsciidocUtil.isAdoc(path) ? this.asciidoctor.load(pageContent, this.options).getStructuredDoctitle().getMain() : this.tagText(pageContent, "h1");
            return StringEscapeUtils.unescapeHtml4((String)title);
        }
        catch (IllegalStateException e) {
            return FilenameUtils.removeExtension((String)path.getFileName().toString());
        }
    }

    private String tagText(String content, String tag) {
        String tagBegin = "<" + tag + ">";
        String tagEnd = "</" + tag + ">";
        try {
            String substring = content.substring(0, content.indexOf(tagEnd));
            return substring.substring(content.indexOf(tagBegin) + tagBegin.length());
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalStateException("Unable to retrieve text of tag '" + tag + "' in content '" + content + "'", e);
        }
    }

    private File parentFolder(Path pagePath) {
        return pagePath.getParent().toFile();
    }

    private Function<String, String> replaceCrossReferenceTargets(Path pagePath) {
        return content -> this.replaceAll((String)content, PAGE_TITLE_PATTERN, matchResult -> {
            String htmlTarget;
            String referencedPageTitle = htmlTarget = matchResult.group(1);
            if (htmlTarget.contains(".")) {
                Path referencedPagePath = pagePath.getParent().resolve(Paths.get(htmlTarget.substring(0, htmlTarget.lastIndexOf(46)) + ".adoc", new String[0]));
                referencedPageTitle = this.getPageTitle(referencedPagePath);
            }
            return "<ri:page ri:content-title=\"" + referencedPageTitle + "\"";
        });
    }

    private BinaryOperator<String> unusedCombiner() {
        return (a, b) -> a;
    }
}

