/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml.classdiagram;

import ch.ifocusit.plantuml.PlantUmlBuilder;
import ch.ifocusit.plantuml.classdiagram.NamesMapper;
import ch.ifocusit.plantuml.classdiagram.model.Association;
import ch.ifocusit.plantuml.classdiagram.model.Package;
import ch.ifocusit.plantuml.classdiagram.model.attribute.Attribute;
import ch.ifocusit.plantuml.classdiagram.model.attribute.ClassAttribute;
import ch.ifocusit.plantuml.classdiagram.model.clazz.Clazz;
import ch.ifocusit.plantuml.classdiagram.model.clazz.JavaClazz;
import ch.ifocusit.plantuml.utils.ClassUtils;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassDiagramBuilder
implements NamesMapper {
    private final Set<java.lang.Package> packages = new LinkedHashSet<java.lang.Package>();
    private final Set<Class> classes = new LinkedHashSet<Class>();
    private Predicate<ClassAttribute> additionalFieldPredicate = a -> true;
    private final PlantUmlBuilder builder = new PlantUmlBuilder();
    private final Set<ClassAttribute> attributs = new LinkedHashSet<ClassAttribute>();
    private NamesMapper namesMapper = this;
    private String header;
    private String footer;
    private final Map<Class, JavaClazz> cache = new HashMap<Class, JavaClazz>();

    public ClassDiagramBuilder setHeader(String header) {
        this.header = header;
        return this;
    }

    public ClassDiagramBuilder setFooter(String footer) {
        this.footer = footer;
        return this;
    }

    public ClassDiagramBuilder excludes(String ... excludes) {
        Predicate<ClassAttribute> notMatch = field -> Stream.of(excludes).noneMatch(excl -> field.toStringAttribute().matches((String)excl));
        this.additionalFieldPredicate = this.additionalFieldPredicate.and(notMatch);
        return this;
    }

    public ClassDiagramBuilder addFieldPredicate(Predicate<ClassAttribute> predicate) {
        this.additionalFieldPredicate = this.additionalFieldPredicate.and(predicate);
        return this;
    }

    public ClassDiagramBuilder addClasse(Iterable<Class> classes) {
        classes.forEach(this.classes::add);
        return this;
    }

    public ClassDiagramBuilder addClasse(Class ... classes) {
        Stream.of(classes).forEach(this.classes::add);
        return this;
    }

    public ClassDiagramBuilder addPackage(java.lang.Package ... packages) {
        Stream.of(packages).forEach(this.packages::add);
        return this;
    }

    public ClassDiagramBuilder withNamesMapper(NamesMapper namesMapper) {
        this.namesMapper = namesMapper;
        return this;
    }

    public String build() {
        this.attributs.clear();
        this.builder.start();
        this.builder.appendPart(this.header);
        this.addPackages();
        this.addTypes();
        this.addAssociations();
        this.builder.appendPart(this.footer);
        this.builder.end();
        return this.builder.build();
    }

    protected void addPackages() {
        this.packages.stream().forEach(pkg -> {
            try {
                ClassPath classPath = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader());
                Clazz[] classes = (Clazz[])classPath.getTopLevelClasses(pkg.getName()).stream().map(ClassPath.ClassInfo::load).map(this::createJavaClass).sorted().toArray(Clazz[]::new);
                this.builder.addPackage(Package.from(pkg), classes);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load classes from package " + pkg, e);
            }
        });
    }

    protected void addTypes() {
        this.classes.forEach(clazz -> this.builder.addType(this.createJavaClass((Class)clazz)));
    }

    protected JavaClazz createJavaClass(Class aClass) {
        return this.cache.computeIfAbsent(aClass, clazz -> JavaClazz.from(clazz, this.readFields((Class)clazz)).setOverridedName(this.namesMapper.getClassName((Class)clazz)).setLink(this.namesMapper.getClassLink((Class)clazz)));
    }

    protected Predicate<ClassAttribute> filter() {
        return this.additionalFieldPredicate;
    }

    protected Attribute[] readFields(Class aClass) {
        return (Attribute[])Stream.of(aClass.getDeclaredFields()).filter(field -> !field.getName().startsWith("$")).filter(field -> field.getDeclaringClass().isEnum() || !Modifier.isStatic(field.getModifiers())).map(this::createClassAttribute).filter(this.filter()).toArray(Attribute[]::new);
    }

    protected ClassAttribute createClassAttribute(Field field) {
        ClassAttribute attribut = new ClassAttribute(field, this.namesMapper.getFieldName(field));
        Optional<ClassAttribute> existing = this.attributs.stream().filter(attr -> attribut.getConcernedTypes().collect(Collectors.toList()).contains(attr.getDeclaringClass()) && attr.getConcernedTypes().collect(Collectors.toList()).contains(attribut.getDeclaringClass())).findFirst();
        if (existing.isPresent()) {
            existing.get().setBidirectionnal(true);
        } else if (!field.getDeclaringClass().isEnum()) {
            this.attributs.add(attribut);
        }
        attribut.setLink(this.namesMapper.getFieldLink(field));
        return attribut;
    }

    protected void addAssociations() {
        this.classes.forEach(aClass -> Stream.concat(Stream.of(aClass.getSuperclass()), ClassUtils.getAllInterfaces((Class)aClass).stream()).filter(Objects::nonNull).filter(this.classes::contains).forEach(parentClass -> this.builder.addAssociation(this.namesMapper.getClassName((Class)parentClass), this.namesMapper.getClassName((Class)aClass), Association.INHERITANCE)));
        this.attributs.stream().filter(field -> field.isManaged(this.classes)).filter(this.filter()).forEach(attr -> attr.getConcernedTypes().filter(this.classes::contains).forEach(aClass -> {
            String aCardinality = attr.isLeftCollection() ? "*" : null;
            String bCardinality = attr.isRightCollection() ? "*" : null;
            String name = attr.getName();
            Association link = attr.isBidirectionnal() ? Association.BI_DIRECTION : Association.DIRECTION;
            this.builder.addAssociation(this.namesMapper.getClassName(attr.getDeclaringClass()), this.namesMapper.getClassName((Class)aClass), link, name, aCardinality, bCardinality);
        }));
    }
}

