/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml.classdiagram.model.attribute;

import ch.ifocusit.plantuml.classdiagram.model.Link;
import ch.ifocusit.plantuml.classdiagram.model.attribute.Attribute;
import ch.ifocusit.plantuml.utils.ClassUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassAttribute
implements Attribute {
    public static final String GENERICS_OPEN = "<";
    public static final String GENERICS_CLOSE = ">";
    public static final String GENERICS_SEP = ", ";
    private final Field field;
    private final String fieldName;
    private Optional<Link> link;
    private boolean bidirectionnal;

    public ClassAttribute(Field field) {
        this(field, field.getName());
    }

    public ClassAttribute(Field field, String fieldName) {
        this.field = field;
        this.fieldName = fieldName;
    }

    @Override
    public Optional<String> getType() {
        if (this.field.getDeclaringClass().isEnum()) {
            return Optional.empty();
        }
        String fieldClassName = ClassUtils.getSimpleName(this.field.getType());
        if (this.field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)this.field.getGenericType();
            String subtypes = Stream.of(genericType.getActualTypeArguments()).map(ClassUtils::getSimpleName).collect(Collectors.joining(GENERICS_SEP));
            fieldClassName = fieldClassName + GENERICS_OPEN + subtypes + GENERICS_CLOSE;
        }
        return Optional.of(fieldClassName);
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    public Field getField() {
        return this.field;
    }

    public Class getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    private Class getFieldType() {
        return this.field.getType();
    }

    public Stream<Class> getConcernedTypes() {
        return ClassUtils.getConcernedTypes(this.field);
    }

    public boolean isManaged(Set<Class> classes) {
        return this.getConcernedTypes().anyMatch(classes::contains);
    }

    public void setBidirectionnal(boolean bidirectionnal) {
        this.bidirectionnal = bidirectionnal;
    }

    public boolean isBidirectionnal() {
        return this.bidirectionnal;
    }

    public boolean isRightCollection() {
        return ClassUtils.isCollection(this.getFieldType());
    }

    public boolean isLeftCollection() {
        Optional<Field> field = ClassUtils.getField(this.getFieldType(), this.getDeclaringClass());
        return field.isPresent() && ClassUtils.isCollection(field.get().getType());
    }

    public String toStringAttribute() {
        return this.field.getDeclaringClass().getName() + "." + this.field.getName();
    }

    @Override
    public Optional<Link> getLink() {
        return this.link;
    }

    public ClassAttribute setLink(Optional<Link> link) {
        this.link = link;
        return this;
    }
}

