/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml.utils;

import com.google.common.base.CharMatcher;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public class ClassUtils
extends org.apache.commons.lang3.ClassUtils {
    public static final String DOLLAR = "$";

    public static String getSimpleName(Type type) {
        return Class.class.isInstance(type) ? org.apache.commons.lang3.ClassUtils.getSimpleName((Class)((Class)Class.class.cast(type))) : type.getTypeName();
    }

    public static String getSimpleName(Class aClass) {
        String className = aClass.getSimpleName();
        int lastDollarSign = className.lastIndexOf(DOLLAR);
        if (lastDollarSign != -1) {
            String innerClassName = className.substring(lastDollarSign + 1);
            return CharMatcher.digit().trimLeadingFrom((CharSequence)innerClassName);
        }
        return className;
    }

    public static boolean isCollection(Class aClass) {
        return Collection.class.isAssignableFrom(aClass);
    }

    public static Optional<Field> getField(Class container, Class aClass) {
        return Stream.of(container.getDeclaredFields()).filter(attr -> ClassUtils.getConcernedTypes(attr).anyMatch(fieldType -> fieldType.equals(aClass))).findFirst();
    }

    public static Stream<Class> getConcernedTypes(Field field) {
        return Stream.concat(Stream.of(field.getType()), ClassUtils.getGenericTypes(field));
    }

    public static Stream<Class> getGenericTypes(Field field) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            return Stream.of(genericType.getActualTypeArguments()).filter(Class.class::isInstance).map(Class.class::cast);
        }
        return Stream.empty();
    }
}

