/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml.classdiagram;

import ch.ifocusit.plantuml.PlantUmlBuilder;
import ch.ifocusit.plantuml.classdiagram.NamesMapper;
import ch.ifocusit.plantuml.classdiagram.model.Association;
import ch.ifocusit.plantuml.classdiagram.model.Cardinality;
import ch.ifocusit.plantuml.classdiagram.model.DiagramMember;
import ch.ifocusit.plantuml.classdiagram.model.Method.ClassMethod;
import ch.ifocusit.plantuml.classdiagram.model.Method.Method;
import ch.ifocusit.plantuml.classdiagram.model.Package;
import ch.ifocusit.plantuml.classdiagram.model.attribute.Attribute;
import ch.ifocusit.plantuml.classdiagram.model.attribute.ClassAttribute;
import ch.ifocusit.plantuml.classdiagram.model.clazz.Clazz;
import ch.ifocusit.plantuml.classdiagram.model.clazz.JavaClazz;
import ch.ifocusit.plantuml.utils.ClassUtils;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassDiagramBuilder
implements NamesMapper {
    private final Set<java.lang.Package> packages = new LinkedHashSet<java.lang.Package>();
    private final Set<Class> classes = new LinkedHashSet<Class>();
    private Predicate<ClassAttribute> additionalFieldPredicate = a -> true;
    private Predicate<ClassMethod> additionalMethodPredicate = a -> true;
    private final PlantUmlBuilder builder = new PlantUmlBuilder();
    private final Set<ClassAttribute> associations = new LinkedHashSet<ClassAttribute>();
    private NamesMapper namesMapper = this;
    private String header;
    private String footer;
    private final Map<Class, JavaClazz> cache = new HashMap<Class, JavaClazz>();

    public ClassDiagramBuilder setHeader(String header) {
        this.header = header;
        return this;
    }

    public ClassDiagramBuilder setFooter(String footer) {
        this.footer = footer;
        return this;
    }

    public ClassDiagramBuilder excludes(String ... excludes) {
        Predicate<ClassAttribute> notMatchField = field -> Stream.of(excludes).noneMatch(excl -> field.toStringAttribute().matches((String)excl));
        this.additionalFieldPredicate = this.additionalFieldPredicate.and(notMatchField);
        Predicate<ClassMethod> notMatchMethod = field -> Stream.of(excludes).noneMatch(excl -> field.toStringMethod().matches((String)excl));
        this.additionalMethodPredicate = this.additionalMethodPredicate.and(notMatchMethod);
        return this;
    }

    public ClassDiagramBuilder addFieldPredicate(Predicate<ClassAttribute> predicate) {
        this.additionalFieldPredicate = this.additionalFieldPredicate.and(predicate);
        return this;
    }

    public ClassDiagramBuilder addMethodPredicate(Predicate<ClassMethod> predicate) {
        this.additionalMethodPredicate = this.additionalMethodPredicate.and(predicate);
        return this;
    }

    public ClassDiagramBuilder addClasse(Iterable<Class> classes) {
        classes.forEach(this.classes::add);
        return this;
    }

    public ClassDiagramBuilder addClasse(Class ... classes) {
        this.classes.addAll(Arrays.asList(classes));
        return this;
    }

    public ClassDiagramBuilder addPackage(java.lang.Package ... packages) {
        this.packages.addAll(Arrays.asList(packages));
        return this;
    }

    public ClassDiagramBuilder withNamesMapper(NamesMapper namesMapper) {
        this.namesMapper = namesMapper;
        return this;
    }

    public String build() {
        this.associations.clear();
        this.builder.start();
        this.builder.appendPart(this.header);
        this.addPackages();
        this.addTypes();
        this.addAssociations();
        this.builder.appendPart(this.footer);
        this.builder.end();
        return this.builder.build();
    }

    protected void addPackages() {
        this.packages.stream().forEach(pkg -> {
            try {
                ClassPath classPath = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader());
                Clazz[] classes = (Clazz[])classPath.getTopLevelClasses(pkg.getName()).stream().map(ClassPath.ClassInfo::load).map(this::createJavaClass).sorted().toArray(Clazz[]::new);
                this.builder.addPackage(Package.from(pkg), classes);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load classes from package " + pkg, e);
            }
        });
    }

    protected void addTypes() {
        this.classes.forEach(clazz -> this.builder.addType(this.createJavaClass((Class)clazz)));
    }

    protected JavaClazz createJavaClass(Class aClass) {
        return this.cache.computeIfAbsent(aClass, clazz -> JavaClazz.from(clazz, this.readFields((Class)clazz), this.readMethods((Class)clazz)).setOverridedName(this.namesMapper.getClassName((Class)clazz)).setLink(this.namesMapper.getClassLink((Class)clazz)));
    }

    protected Predicate<ClassAttribute> filterFields() {
        return this.additionalFieldPredicate;
    }

    protected Predicate<ClassMethod> filterMethods() {
        return this.additionalMethodPredicate;
    }

    protected Method[] readMethods(Class aClass) {
        return (Method[])Stream.of(aClass.getDeclaredMethods()).filter(method -> !Modifier.isStatic(method.getModifiers())).map(this::createClassMethod).filter(this.filterMethods()).toArray(Method[]::new);
    }

    protected ClassMethod createClassMethod(java.lang.reflect.Method method) {
        ClassMethod classMethod = new ClassMethod(method, this.namesMapper.getMethodName(method));
        classMethod.setLink(this.namesMapper.getMethodLink(method));
        return classMethod;
    }

    protected Attribute[] readFields(Class aClass) {
        return (Attribute[])Stream.of(aClass.getDeclaredFields()).filter(field -> !field.getName().startsWith("$")).filter(field -> field.getDeclaringClass().isEnum() || !Modifier.isStatic(field.getModifiers())).map(this::createClassAttribute).filter(this.filterFields()).toArray(Attribute[]::new);
    }

    protected ClassAttribute createClassAttribute(Field field) {
        ClassAttribute attribut = new ClassAttribute(field, this.namesMapper.getFieldName(field));
        Optional<ClassAttribute> existing = this.associations.stream().filter(attr -> attribut.getConcernedTypes().collect(Collectors.toList()).contains(attr.getDeclaringClass()) && attr.getConcernedTypes().collect(Collectors.toList()).contains(attribut.getDeclaringClass())).findFirst();
        if (existing.isPresent()) {
            existing.get().setBidirectional(true);
        } else if (!field.getDeclaringClass().isEnum()) {
            this.associations.add(attribut);
        }
        attribut.setLink(this.namesMapper.getFieldLink(field));
        return attribut;
    }

    protected void addAssociations() {
        this.classes.forEach(aClass -> Stream.concat(Stream.of(aClass.getSuperclass()), ClassUtils.getAllInterfaces((Class)aClass).stream()).filter(Objects::nonNull).filter(this.classes::contains).forEach(parentClass -> this.builder.addAssociation(this.namesMapper.getClassName((Class)parentClass), this.namesMapper.getClassName((Class)aClass), Association.INHERITANCE)));
        this.associations.stream().filter(field -> field.isManaged(this.classes)).filter(this.filterFields()).forEach(this::addAssociation);
    }

    private void addAssociation(DiagramMember member) {
        member.getConcernedTypes().filter(this.classes::contains).forEach(aClass -> {
            Cardinality aCardinality = member.isLeftCollection() ? Cardinality.MANY : Cardinality.NONE;
            Cardinality bCardinality = member.isRightCollection() ? Cardinality.MANY : Cardinality.NONE;
            String name = member.getName();
            Association type = member instanceof ClassMethod ? Association.LINK : (member.isBidirectional() ? Association.BI_DIRECTION : Association.DIRECTION);
            this.builder.addAssociation(this.namesMapper.getClassName(member.getDeclaringClass()), this.namesMapper.getClassName((Class)aClass), type, name, aCardinality, bCardinality);
        });
    }
}

