/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml.classdiagram.model.Method;

import ch.ifocusit.plantuml.classdiagram.model.DiagramMember;
import ch.ifocusit.plantuml.classdiagram.model.Link;
import ch.ifocusit.plantuml.classdiagram.model.Method.Method;
import ch.ifocusit.plantuml.classdiagram.model.attribute.Attribute;
import ch.ifocusit.plantuml.classdiagram.model.attribute.SimpleAttribute;
import ch.ifocusit.plantuml.utils.ClassUtils;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class ClassMethod
implements Method,
DiagramMember {
    private final java.lang.reflect.Method method;
    private final String methodName;
    private Optional<Link> link;
    private boolean bidirectionnal;

    public ClassMethod(java.lang.reflect.Method method) {
        this(method, method.getName());
    }

    public ClassMethod(java.lang.reflect.Method method, String methodName) {
        this.method = method;
        this.methodName = methodName;
    }

    @Override
    public Optional<String> getReturnType() {
        return Optional.ofNullable(this.method.getReturnType().equals(Void.TYPE) ? null : ClassUtils.getSimpleName(this.method.getGenericReturnType()));
    }

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public Optional<Attribute[]> getParameters() {
        return Optional.of(Stream.of(this.method.getParameters()).map(param -> new SimpleAttribute(param.getName(), ClassUtils.getSimpleName(param.getParameterizedType()))).toArray(Attribute[]::new));
    }

    public java.lang.reflect.Method getMethod() {
        return this.method;
    }

    @Override
    public Class getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    private Class getMethodReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public Stream<Class> getConcernedTypes() {
        return ClassUtils.getConcernedTypes(this.method);
    }

    public boolean isManaged(Set<Class> classes) {
        return this.getConcernedTypes().anyMatch(classes::contains);
    }

    public void setBidirectionnal(boolean bidirectionnal) {
        this.bidirectionnal = bidirectionnal;
    }

    @Override
    public boolean isBidirectional() {
        return this.bidirectionnal;
    }

    @Override
    public boolean isRightCollection() {
        return ClassUtils.isCollection(this.getMethodReturnType());
    }

    @Override
    public boolean isLeftCollection() {
        Optional<Field> field = ClassUtils.getField(this.getMethodReturnType(), this.getDeclaringClass());
        return field.isPresent() && ClassUtils.isCollection(field.get().getType());
    }

    public String toStringMethod() {
        return this.method.getDeclaringClass().getName() + "." + this.method.getName();
    }

    @Override
    public Optional<Link> getLink() {
        return this.link;
    }

    public ClassMethod setLink(Optional<Link> link) {
        this.link = link;
        return this;
    }
}

