/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml.classdiagram.model.attribute;

import ch.ifocusit.plantuml.classdiagram.model.DiagramMember;
import ch.ifocusit.plantuml.classdiagram.model.Link;
import ch.ifocusit.plantuml.classdiagram.model.attribute.Attribute;
import ch.ifocusit.plantuml.utils.ClassUtils;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class ClassAttribute
implements Attribute,
DiagramMember {
    private final Field field;
    private final String fieldName;
    private Optional<Link> link;
    private boolean bidirectional;

    public ClassAttribute(Field field) {
        this(field, field.getName());
    }

    public ClassAttribute(Field field, String fieldName) {
        this.field = field;
        this.fieldName = fieldName;
    }

    @Override
    public Optional<String> getType() {
        if (this.field.getDeclaringClass().isEnum()) {
            return Optional.empty();
        }
        return Optional.of(ClassUtils.getSimpleName(this.field.getGenericType()));
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public Class getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    private Class getFieldType() {
        return this.field.getType();
    }

    @Override
    public Stream<Class> getConcernedTypes() {
        return ClassUtils.getConcernedTypes(this.field);
    }

    public boolean isManaged(Set<Class> classes) {
        return this.getConcernedTypes().anyMatch(classes::contains);
    }

    public void setBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
    }

    @Override
    public boolean isBidirectional() {
        return this.bidirectional;
    }

    @Override
    public boolean isRightCollection() {
        return ClassUtils.isCollection(this.getFieldType());
    }

    @Override
    public boolean isLeftCollection() {
        Optional<Field> field = ClassUtils.getField(this.getFieldType(), this.getDeclaringClass());
        return field.isPresent() && ClassUtils.isCollection(field.get().getType());
    }

    public String toStringAttribute() {
        return this.field.getDeclaringClass().getName() + "." + this.field.getName();
    }

    @Override
    public Optional<Link> getLink() {
        return this.link;
    }

    public ClassAttribute setLink(Optional<Link> link) {
        this.link = link;
        return this;
    }
}

