/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml.classdiagram.model.clazz;

import ch.ifocusit.plantuml.classdiagram.model.Link;
import ch.ifocusit.plantuml.classdiagram.model.Method.Method;
import ch.ifocusit.plantuml.classdiagram.model.attribute.Attribute;
import ch.ifocusit.plantuml.classdiagram.model.clazz.Clazz;
import ch.ifocusit.plantuml.utils.ClassUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class JavaClazz
implements Clazz {
    private final Class<?> relatedClass;
    private Optional<String> overridedName;
    private Optional<Link> link;
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private List<Method> methods = new ArrayList<Method>();
    private String backgroundColor;
    private String borderColor;

    public JavaClazz(Class<?> relatedClass) {
        this.relatedClass = relatedClass;
    }

    @Override
    public String getName() {
        return this.overridedName.orElse(ClassUtils.getSimpleName(this.relatedClass));
    }

    @Override
    public Clazz.Type getType() {
        return this.parseType(this.relatedClass);
    }

    @Override
    public Optional<Link> getLink() {
        return this.link;
    }

    public JavaClazz setLink(Optional<Link> link) {
        this.link = link;
        return this;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void addAttributes(Attribute ... attributes) {
        for (Attribute attribute : attributes) {
            this.attributes.add(attribute);
        }
    }

    @Override
    public List<Method> getMethods() {
        return this.methods;
    }

    public void addMethods(Method ... methods) {
        for (Method method : methods) {
            this.methods.add(method);
        }
    }

    public JavaClazz setOverridedName(String overridedName) {
        this.overridedName = Optional.ofNullable(overridedName);
        return this;
    }

    @Override
    public Optional<List<String>> getStereotypes() {
        return Optional.empty();
    }

    private Clazz.Type parseType(Class aClass) {
        if (aClass.isInterface()) {
            return Clazz.Type.INTERFACE;
        }
        if (aClass.isEnum()) {
            return Clazz.Type.ENUM;
        }
        if (Modifier.isAbstract(aClass.getModifiers())) {
            return Clazz.Type.ABSTRACT;
        }
        return Clazz.Type.CLASS;
    }

    @Override
    public Optional<String> getBackgroundColor() {
        return Optional.ofNullable(this.backgroundColor);
    }

    @Override
    public Optional<String> getBorderColor() {
        return Optional.ofNullable(this.borderColor);
    }

    public JavaClazz setBackgroundColor(String color) {
        this.backgroundColor = color;
        return this;
    }

    public JavaClazz setBorderColor(String color) {
        this.borderColor = color;
        return this;
    }

    public static JavaClazz from(Class aClass, Attribute[] attributes, Method[] methods) {
        JavaClazz javaClass = new JavaClazz(aClass);
        javaClass.addAttributes(attributes);
        javaClass.addMethods(methods);
        return javaClass;
    }
}

