/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml.utils;

import com.google.common.base.CharMatcher;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassUtils
extends org.apache.commons.lang3.ClassUtils {
    public static final String GENERICS_OPEN = "<";
    public static final String GENERICS_CLOSE = ">";
    public static final String GENERICS_SEP = ", ";
    public static final String DOLLAR = "$";

    public static String getSimpleName(Class aClass) {
        return ClassUtils._getSimpleName(aClass);
    }

    public static String _getSimpleName(Class aClass) {
        String className = aClass.getSimpleName();
        int lastDollarSign = className.lastIndexOf(DOLLAR);
        if (lastDollarSign != -1) {
            String innerClassName = className.substring(lastDollarSign + 1);
            return CharMatcher.digit().trimLeadingFrom((CharSequence)innerClassName);
        }
        return className;
    }

    public static String getSimpleName(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)type;
            return ClassUtils.getSimpleName(genericType.getRawType()) + ClassUtils.getParameterizedTypeName(genericType);
        }
        if (type instanceof Class) {
            return ClassUtils._getSimpleName((Class)type);
        }
        return type.getTypeName();
    }

    public static String getParameterizedTypeName(ParameterizedType genericType) {
        String subtypes = Stream.of(genericType.getActualTypeArguments()).map(ClassUtils::getSimpleName).collect(Collectors.joining(GENERICS_SEP));
        return GENERICS_OPEN + subtypes + GENERICS_CLOSE;
    }

    public static boolean isCollection(Class aClass) {
        return Collection.class.isAssignableFrom(aClass);
    }

    public static Optional<Field> getField(Class container, Class aClass) {
        return Stream.of(container.getDeclaredFields()).filter(attr -> ClassUtils.getConcernedTypes(attr).anyMatch(fieldType -> fieldType.equals(aClass))).findFirst();
    }

    public static Stream<Class> getConcernedTypes(Field field) {
        return Stream.concat(Stream.of(field.getType()), ClassUtils.getGenericTypes(field));
    }

    public static Stream<Class> getGenericTypes(Field field) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            return Stream.of(genericType.getActualTypeArguments()).filter(Class.class::isInstance).map(Class.class::cast);
        }
        return Stream.empty();
    }

    public static Stream<Class> getConcernedTypes(Method method) {
        return Stream.concat(Stream.of(method.getReturnType()), ClassUtils.getGenericTypes(method));
    }

    public static Stream<Class> getGenericTypes(Method method) {
        if (method.getGenericReturnType() instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)method.getGenericReturnType();
            return Stream.of(genericType.getActualTypeArguments()).filter(Class.class::isInstance).map(Class.class::cast);
        }
        return Stream.empty();
    }
}

