/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml.classdiagram.model.method;

import ch.ifocusit.plantuml.classdiagram.model.ClassMember;
import ch.ifocusit.plantuml.classdiagram.model.Link;
import ch.ifocusit.plantuml.classdiagram.model.attribute.MethodAttribute;
import ch.ifocusit.plantuml.classdiagram.model.method.Method;
import ch.ifocusit.plantuml.utils.ClassUtils;
import java.lang.reflect.Parameter;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class ClassMethod
implements Method,
ClassMember {
    private final java.lang.reflect.Method method;
    private final String methodName;
    private Optional<Link> link;

    public ClassMethod(java.lang.reflect.Method method) {
        this(method, method.getName());
    }

    public ClassMethod(java.lang.reflect.Method method, String methodName) {
        this.method = method;
        this.methodName = methodName;
    }

    @Override
    public Optional<String> getReturnTypeName() {
        return Optional.ofNullable(this.method.getReturnType().equals(Void.TYPE) ? null : ClassUtils.getSimpleName(this.method.getGenericReturnType()));
    }

    @Override
    public Class getType() {
        return this.getMethod().getReturnType();
    }

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public Optional<MethodAttribute[]> getParameters() {
        return Optional.of(Stream.of(this.method.getParameters()).map(param -> new MethodAttribute((Parameter)param)).toArray(MethodAttribute[]::new));
    }

    public java.lang.reflect.Method getMethod() {
        return this.method;
    }

    @Override
    public Class getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    private Class getMethodReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public Set<Class> getConcernedTypes() {
        return ClassUtils.getConcernedTypes(this.method);
    }

    public Set<Class> getConcernedReturnedTypes() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(this.method.getReturnType());
        classes.addAll(ClassUtils.getGenericTypes(this.method));
        return classes;
    }

    public String toStringMethod() {
        return this.method.getDeclaringClass().getName() + "." + this.method.getName();
    }

    @Override
    public Optional<Link> getLink() {
        return this.link;
    }

    public ClassMethod setLink(Optional<Link> link) {
        this.link = link;
        return this;
    }
}

