/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml;

import ch.ifocusit.plantuml.classdiagram.model.Association;
import ch.ifocusit.plantuml.classdiagram.model.Cardinality;
import ch.ifocusit.plantuml.classdiagram.model.Package;
import ch.ifocusit.plantuml.classdiagram.model.attribute.Attribute;
import ch.ifocusit.plantuml.classdiagram.model.clazz.Clazz;
import java.text.MessageFormat;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class PlantUmlBuilder {
    private static final String STARTUML = "@startuml";
    private static final String ENDUML = "@enduml";
    public static final String SEMICOLON = ":";
    public static final String COMMA = ",";
    public static final String BRACE_OPEN = "{";
    public static final String BRACE_CLOSE = "}";
    public static final String STEREOTYPE_OPEN = "<<";
    public static final String STEREOTYPE_CLOSE = ">>";
    public static final String TAB = "  ";
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String QUOTE = "\"";
    public static final String HASHTAG = "#";
    public static final String PACKAGE_TMPL = "package {0} <<{1}>>";
    public static final String BRACKET_OPEN = "(";
    public static final String BRACKET_CLOSE = ")";
    private final StringBuilder content = new StringBuilder();

    public PlantUmlBuilder start() {
        this.content.append(STARTUML).append(NEWLINE).append(NEWLINE);
        return this;
    }

    public PlantUmlBuilder end() {
        this.content.append(NEWLINE).append(ENDUML);
        return this;
    }

    public String build() {
        return this.content.toString();
    }

    private String escape(String value) {
        return QUOTE + value + QUOTE;
    }

    private String color(String color) {
        return HASHTAG + color;
    }

    private PlantUmlBuilder writeClazzDefinition(Clazz clazz) {
        this.content.append((Object)clazz.getType()).append(" ").append(this.escape(clazz.getName()));
        return this;
    }

    private PlantUmlBuilder append(String s) {
        if (s != null) {
            this.content.append(s);
        }
        return this;
    }

    public PlantUmlBuilder appendHeader(String header) {
        if (header != null) {
            this.content.append("header").append(NEWLINE).append(header).append(NEWLINE).append("endheader").append(NEWLINE).append(NEWLINE);
        }
        return this;
    }

    public PlantUmlBuilder appendFooter(String footer) {
        if (footer != null) {
            this.content.append("footer").append(NEWLINE).append(footer).append(NEWLINE).append("endfooter").append(NEWLINE).append(NEWLINE);
        }
        return this;
    }

    public PlantUmlBuilder addPackage(Package aPackage, Clazz ... classes) {
        Validate.notNull((Object)aPackage, (String)"no package defined !", (Object[])new Object[0]);
        aPackage.validate();
        Validate.notEmpty((Object[])classes, (String)String.format("Package '%s' must not be empty !", aPackage.getName()), (Object[])new Object[0]);
        this.content.append(MessageFormat.format(PACKAGE_TMPL, new Object[]{aPackage.getName(), aPackage.getType()}));
        aPackage.getColor().ifPresent(color -> this.content.append(" ").append(this.color((String)color)));
        if (classes.length > 0) {
            this.content.append(" ").append(BRACE_OPEN).append(NEWLINE);
            Stream.of(classes).forEach(clazz -> {
                clazz.validate();
                this.append(TAB).writeClazzDefinition((Clazz)clazz).append(NEWLINE);
            });
            this.content.append(BRACE_CLOSE);
        }
        this.content.append(NEWLINE).append(NEWLINE);
        return this;
    }

    public PlantUmlBuilder addType(Clazz clazz) {
        Validate.notNull((Object)clazz, (String)"No class defined !", (Object[])new Object[0]);
        clazz.validate();
        this.writeClazzDefinition(clazz);
        clazz.getStereotypes().ifPresent(stereotypes -> this.content.append(" ").append(STEREOTYPE_OPEN).append(stereotypes.stream().collect(Collectors.joining(", "))).append(STEREOTYPE_CLOSE));
        clazz.getLink().ifPresent(link -> this.content.append(" ").append(link.toString()));
        clazz.getBackgroundColor().ifPresent(color -> this.content.append(" ").append(this.color((String)color)));
        if (clazz.hasContent()) {
            this.content.append(" ").append(BRACE_OPEN).append(NEWLINE);
        }
        for (Attribute attribute : clazz.getAttributes()) {
            this.content.append(TAB).append(attribute.getName());
            attribute.getTypeName().ifPresent(type -> this.content.append(" ").append(SEMICOLON).append(" ").append((String)type));
            attribute.getLink().ifPresent(link -> this.content.append(" ").append(link.toString()));
            this.content.append(NEWLINE);
        }
        clazz.getMethods().stream().forEach(method -> {
            this.content.append(TAB).append(method.getName());
            method.getParameters().ifPresent(params -> {
                this.content.append(BRACKET_OPEN);
                this.content.append(Stream.of(params).map(param -> param.getTypeName().orElse(param.getName())).collect(Collectors.joining(", ")));
                this.content.append(BRACKET_CLOSE);
            });
            method.getReturnTypeName().ifPresent(type -> this.content.append(" ").append(SEMICOLON).append(" ").append((String)type));
            method.getLink().ifPresent(link -> this.content.append(" ").append(link.toString()));
            this.content.append(NEWLINE);
        });
        if (clazz.hasContent()) {
            this.content.append(BRACE_CLOSE);
        }
        if (!clazz.getAttributes().isEmpty()) {
            // empty if block
        }
        this.content.append(NEWLINE).append(NEWLINE);
        return this;
    }

    public PlantUmlBuilder addAssociation(String aName, String bName) {
        return this.addAssociation(aName, bName, Association.AssociationType.DIRECTION, null);
    }

    public PlantUmlBuilder addAssociation(String aName, String bName, Association.AssociationType type) {
        return this.addAssociation(aName, bName, type, null);
    }

    public PlantUmlBuilder addAssociation(String aName, String bName, String label) {
        return this.addAssociation(aName, bName, Association.AssociationType.DIRECTION, label);
    }

    public PlantUmlBuilder addAssociation(String aName, String bName, Association.AssociationType type, String label) {
        return this.addAssociation(aName, bName, type, label, Cardinality.NONE, Cardinality.NONE);
    }

    public PlantUmlBuilder addAssociation(Association association) {
        return this.addAssociation(association.getaName(), association.getbName(), association.getType(), association.getLabel(), association.getaCardinality(), association.getbCardinality());
    }

    public PlantUmlBuilder addAssociation(String aName, String bName, Association.AssociationType type, String label, Cardinality aCardinality, Cardinality bCardinality) {
        Validate.notBlank((CharSequence)aName, (String)"Class a name is mandatory", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)bName, (String)"Class b name is mandatory", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)type), (String)"Association type is mandatory", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)aCardinality), (String)"Cardinality a name is mandatory", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)bCardinality), (String)"Cardinality b name is mandatory", (Object[])new Object[0]);
        this.content.append(this.escape(aName));
        if (!Cardinality.NONE.equals((Object)aCardinality)) {
            this.content.append(" ").append(QUOTE).append((Object)aCardinality).append(QUOTE);
        }
        this.content.append(" ").append((Object)type).append(" ");
        if (!Cardinality.NONE.equals((Object)bCardinality)) {
            this.content.append(QUOTE).append((Object)bCardinality).append(QUOTE).append(" ");
        }
        this.content.append(this.escape(bName));
        if (StringUtils.isNotBlank((CharSequence)label)) {
            this.content.append(" ").append(SEMICOLON).append(" ").append(label);
        }
        this.content.append(NEWLINE);
        return this;
    }
}

