/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml.utils;

import com.google.common.base.CharMatcher;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassUtils
extends org.apache.commons.lang3.ClassUtils {
    public static final String GENERICS_OPEN = "<";
    public static final String GENERICS_CLOSE = ">";
    public static final String GENERICS_SEP = ", ";
    public static final String DOLLAR = "$";

    public static String getSimpleName(Class aClass) {
        return ClassUtils._getSimpleName(aClass);
    }

    public static String _getSimpleName(Class aClass) {
        String className = aClass.getSimpleName();
        int lastDollarSign = className.lastIndexOf(DOLLAR);
        if (lastDollarSign != -1) {
            String innerClassName = className.substring(lastDollarSign + 1);
            return CharMatcher.digit().trimLeadingFrom((CharSequence)innerClassName);
        }
        return className;
    }

    public static String getSimpleName(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)type;
            return ClassUtils.getSimpleName(genericType.getRawType()) + ClassUtils.getParameterizedTypeName(genericType);
        }
        if (type instanceof Class) {
            return ClassUtils._getSimpleName((Class)type);
        }
        return type.getTypeName();
    }

    public static String getParameterizedTypeName(ParameterizedType genericType) {
        String subtypes = Stream.of(genericType.getActualTypeArguments()).map(ClassUtils::getSimpleName).collect(Collectors.joining(GENERICS_SEP));
        return GENERICS_OPEN + subtypes + GENERICS_CLOSE;
    }

    public static boolean isCollection(Class aClass) {
        return Collection.class.isAssignableFrom(aClass);
    }

    public static Optional<Field> getField(Class container, Class aClass) {
        return Stream.of(container.getDeclaredFields()).filter(attr -> ClassUtils.getConcernedTypes(attr).stream().anyMatch(fieldType -> fieldType.equals(aClass))).findFirst();
    }

    public static Set<Class> getConcernedTypes(Field field) {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(field.getType());
        classes.addAll(ClassUtils.getGenericTypes(field));
        return classes;
    }

    public static Set<Class> getConcernedTypes(Method method) {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(method.getReturnType());
        classes.addAll(ClassUtils.getGenericTypes(method));
        for (Parameter parameter : method.getParameters()) {
            classes.addAll(ClassUtils.getConcernedTypes(parameter));
        }
        return classes;
    }

    public static Set<Class> getConcernedTypes(Parameter parameter) {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(parameter.getType());
        classes.addAll(ClassUtils.getGenericTypes(parameter));
        return classes;
    }

    public static Set<Class> getGenericTypes(ParameterizedType type) {
        return Stream.of(type.getActualTypeArguments()).filter(Class.class::isInstance).map(Class.class::cast).collect(Collectors.toSet());
    }

    public static Set<Class> getGenericTypes(Field field) {
        if (field.getGenericType() instanceof ParameterizedType) {
            return ClassUtils.getGenericTypes((ParameterizedType)field.getGenericType());
        }
        return new HashSet<Class>();
    }

    public static Set<Class> getGenericTypes(Method method) {
        if (method.getGenericReturnType() instanceof ParameterizedType) {
            return ClassUtils.getGenericTypes((ParameterizedType)method.getGenericReturnType());
        }
        return new HashSet<Class>();
    }

    public static Set<Class> getGenericTypes(Parameter parameter) {
        if (parameter.getParameterizedType() instanceof ParameterizedType) {
            return ClassUtils.getGenericTypes((ParameterizedType)parameter.getParameterizedType());
        }
        return new HashSet<Class>();
    }

    public static boolean isGetter(Method method) {
        try {
            return Stream.of(Introspector.getBeanInfo(method.getDeclaringClass()).getPropertyDescriptors()).map(desc -> desc.getReadMethod()).filter(Objects::nonNull).anyMatch(getter -> getter.equals(method));
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isSetter(Method method) {
        try {
            return Stream.of(Introspector.getBeanInfo(method.getDeclaringClass()).getPropertyDescriptors()).map(desc -> desc.getWriteMethod()).filter(Objects::nonNull).anyMatch(setter -> setter.equals(method));
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isNotGetterSetter(Method method) {
        return !ClassUtils.isGetter(method) && !ClassUtils.isSetter(method);
    }
}

