/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml.classdiagram;

import ch.ifocusit.plantuml.classdiagram.AbstractClassDiagramBuilder;
import ch.ifocusit.plantuml.classdiagram.NamesMapper;
import ch.ifocusit.plantuml.classdiagram.model.Association;
import ch.ifocusit.plantuml.classdiagram.model.Cardinality;
import ch.ifocusit.plantuml.classdiagram.model.ClassMember;
import ch.ifocusit.plantuml.classdiagram.model.Package;
import ch.ifocusit.plantuml.classdiagram.model.attribute.ClassAttribute;
import ch.ifocusit.plantuml.classdiagram.model.attribute.MethodAttribute;
import ch.ifocusit.plantuml.classdiagram.model.clazz.Clazz;
import ch.ifocusit.plantuml.classdiagram.model.clazz.JavaClazz;
import ch.ifocusit.plantuml.classdiagram.model.method.ClassMethod;
import ch.ifocusit.plantuml.utils.ClassUtils;
import com.google.common.collect.Sets;
import com.google.common.reflect.ClassPath;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ClassDiagramBuilder
extends AbstractClassDiagramBuilder
implements NamesMapper {
    private final Set<java.lang.Package> packages = new LinkedHashSet<java.lang.Package>();
    private final Set<Class> classesRepository = new LinkedHashSet<Class>();
    private final Predicate<ClassAttribute> additionalFieldPredicate = a -> true;
    private NamesMapper namesMapper = this;

    public static void writeDiagramToFile(String filename, Class<?> ... classes) throws IOException {
        ClassDiagramBuilder.writeDiagramToFile(new File(filename), classes);
    }

    public static void writeDiagramToFile(File file, Class<?> ... classes) throws IOException {
        String diagram = new ClassDiagramBuilder().addClasses(classes).build();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(diagram);
        }
    }

    public static void writeDiagramToFile(Path path, Class<?> ... classes) throws IOException {
        String diagram = new ClassDiagramBuilder().addClasses(classes).build();
        Files.write(path, diagram.getBytes(), new OpenOption[0]);
    }

    public ClassDiagramBuilder addClasses(Iterable<Class> classes) {
        classes.forEach(this.classesRepository::add);
        return this;
    }

    public ClassDiagramBuilder addClasses(Class ... classes) {
        this.classesRepository.addAll(Arrays.asList(classes));
        return this;
    }

    public ClassDiagramBuilder addPackage(java.lang.Package ... packages) {
        this.packages.addAll(Arrays.asList(packages));
        return this;
    }

    public ClassDiagramBuilder withNamesMapper(NamesMapper namesMapper) {
        this.namesMapper = namesMapper;
        return this;
    }

    @Override
    public void addPackages() {
        this.packages.forEach(pkg -> {
            try {
                ClassPath classPath = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader());
                Clazz[] classes = (Clazz[])classPath.getTopLevelClasses(pkg.getName()).stream().map(ClassPath.ClassInfo::load).map(this::createJavaClass).sorted().toArray(Clazz[]::new);
                this.builder.addPackage(Package.from(pkg), classes);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load classesRepository from package " + String.valueOf(pkg), e);
            }
        });
    }

    public boolean canAppearsInDiagram(Class aClass) {
        return !"void".equals(aClass.getName()) && !aClass.getName().startsWith("java.") && (this.withDependencies || this.classesRepository.contains(aClass));
    }

    @Override
    public void detectAssociations() {
        this.clazzes.forEach(javaClazz -> {
            Stream.concat(Stream.of(javaClazz.getRelatedClass().getSuperclass()), org.apache.commons.lang3.ClassUtils.getAllInterfaces(javaClazz.getRelatedClass()).stream()).filter(Objects::nonNull).filter(this::canAppearsInDiagram).forEach(hierarchicalClass -> {
                ClassAssociation assoc = new ClassAssociation();
                assoc.classB = javaClazz.getRelatedClass();
                assoc.classA = hierarchicalClass;
                assoc.setbName(this.namesMapper.getClassName(assoc.classB));
                assoc.setbCardinality(Cardinality.NONE);
                assoc.setaName(this.namesMapper.getClassName(assoc.classA));
                assoc.setaCardinality(Cardinality.NONE);
                assoc.setLabel("");
                assoc.setType(Association.AssociationType.INHERITANCE);
                this.detectedAssociations.add(assoc);
            });
            if (!this.hideFields((JavaClazz)javaClazz)) {
                javaClazz.getAttributes().stream().filter(attribute -> !attribute.getField().isEnumConstant()).forEach(classAttribute -> classAttribute.getConcernedTypes().stream().filter(this::canAppearsInDiagram).forEach(classToLinkWith -> this.addOrUpdateAssociation(javaClazz.getRelatedClass(), (Class)classToLinkWith, (ClassMember)classAttribute)));
            }
            if (!this.hideMethods((JavaClazz)javaClazz)) {
                javaClazz.getMethods().forEach(classMethod -> {
                    classMethod.getParameters().ifPresent(methodAttributes -> Stream.of(methodAttributes).forEach(methodAttribute -> methodAttribute.getConcernedTypes().stream().filter(this::canAppearsInDiagram).forEach(classToLinkWith -> this.addOrUpdateAssociation(javaClazz.getRelatedClass(), (Class)classToLinkWith, (ClassMember)methodAttribute))));
                    classMethod.getConcernedReturnedTypes().stream().filter(this::canAppearsInDiagram).forEach(classToLinkWith -> this.addOrUpdateAssociation(javaClazz.getRelatedClass(), (Class)classToLinkWith, (ClassMember)classMethod));
                });
            }
        });
    }

    private void addOrUpdateAssociation(Class originClass, Class classToLinkWith, ClassMember classMember) {
        if (this.hideSelfLink && originClass.equals(classToLinkWith)) {
            return;
        }
        Optional<Association> existing = this.detectedAssociations.stream().filter(assoc -> ((ClassAssociation)assoc).concern(originClass, classToLinkWith)).findFirst();
        Class typeWithGeneric = classMember.getType();
        Object label = "use";
        if (classMember instanceof MethodAttribute) {
            label = (String)label + (String)(classMember.getName().startsWith("arg") ? "" : " as " + classMember.getName());
        } else if (classMember instanceof ClassAttribute) {
            label = classMember.getName();
        }
        if (existing.isPresent()) {
            if (((ClassAssociation)existing.get()).isNoSameOrigin(originClass)) {
                ((ClassAssociation)existing.get()).setBidirectional();
            }
            if (classMember instanceof ClassAttribute) {
                existing.get().setaCardinality(ClassUtils.isCollection(typeWithGeneric) ? Cardinality.MANY : Cardinality.NONE);
                existing.get().setLabel(existing.get().getLabel() + "/" + (String)label);
            }
        } else {
            ClassAssociation assoc2 = new ClassAssociation();
            assoc2.classA = originClass;
            assoc2.setaName(this.namesMapper.getClassName(assoc2.classA));
            assoc2.setaCardinality(ClassUtils.isCollection(assoc2.classA) ? Cardinality.MANY : Cardinality.NONE);
            assoc2.classB = classToLinkWith;
            assoc2.setbName(this.namesMapper.getClassName(assoc2.classB));
            assoc2.setbCardinality(ClassUtils.isCollection(typeWithGeneric) ? Cardinality.MANY : Cardinality.NONE);
            assoc2.setLabel((String)label);
            assoc2.setType(Association.AssociationType.DIRECTION);
            this.detectedAssociations.add(assoc2);
        }
    }

    @Override
    public void readClasses() {
        this.classesRepository.forEach(clazz -> this.clazzes.add(this.createJavaClass((Class)clazz)));
    }

    public JavaClazz createJavaClass(Class clazz) {
        return JavaClazz.from(clazz, this.readFields(clazz), this.readMethods(clazz)).setOverridedName(this.namesMapper.getClassName(clazz)).setLink(this.linkMaker.getClassLink(clazz).orElse(null));
    }

    public ClassMethod[] readMethods(Class aClass) {
        return (ClassMethod[])Stream.of(aClass.getDeclaredMethods()).filter(method -> !Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers())).map(this::createClassMethod).filter(this.filterMethods()).sorted().toArray(ClassMethod[]::new);
    }

    public ClassMethod createClassMethod(Method method) {
        ClassMethod classMethod = new ClassMethod(method, this.namesMapper.getMethodName(method));
        classMethod.setLink(this.linkMaker.getMethodLink(method).orElse(null));
        return classMethod;
    }

    public ClassAttribute[] readFields(Class aClass) {
        return (ClassAttribute[])Stream.of(aClass.getDeclaredFields()).filter(field -> !field.getName().startsWith("$")).filter(field -> field.getDeclaringClass().isEnum() || !Modifier.isStatic(field.getModifiers())).map(this::createClassAttribute).filter(this.filterFields()).toArray(ClassAttribute[]::new);
    }

    public ClassAttribute createClassAttribute(Field field) {
        ClassAttribute attribute = new ClassAttribute(field, this.namesMapper.getFieldName(field));
        attribute.setLink(this.linkMaker.getFieldLink(field).orElse(null));
        return attribute;
    }

    private static class ClassAssociation
    extends Association
    implements Comparable<ClassAssociation> {
        private Class classA;
        private Class classB;

        private ClassAssociation() {
        }

        public void setBidirectional() {
            this.type = Association.AssociationType.BI_DIRECTION;
        }

        public boolean concern(Class otherA, Class otherB) {
            return Sets.intersection((Set)Sets.newHashSet((Object[])new Class[]{this.classA, this.classB}), (Set)Sets.newHashSet((Object[])new Class[]{otherA, otherB})).size() == 2;
        }

        @Override
        public int compareTo(ClassAssociation o) {
            return this.getKey().compareTo(o.getKey());
        }

        private String getKey() {
            return this.aName + this.bName;
        }

        public boolean isNoSameOrigin(Class initialClass) {
            return !this.classA.equals(initialClass);
        }
    }
}

