/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml.classdiagram.model.attribute;

import ch.ifocusit.plantuml.classdiagram.model.ClassMember;
import ch.ifocusit.plantuml.classdiagram.model.Link;
import ch.ifocusit.plantuml.classdiagram.model.attribute.Attribute;
import ch.ifocusit.plantuml.utils.ClassUtils;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Set;

public class ClassAttribute
implements Attribute,
ClassMember {
    private final Field field;
    private final String fieldName;
    private Link link;

    public ClassAttribute(Field field) {
        this(field, field.getName());
    }

    public ClassAttribute(Field field, String fieldName) {
        this.field = field;
        this.fieldName = fieldName;
    }

    @Override
    public Optional<String> getTypeName() {
        if (this.field.getDeclaringClass().isEnum()) {
            return Optional.empty();
        }
        return Optional.of(ClassUtils.getSimpleName(this.field.getGenericType()));
    }

    @Override
    public Class getType() {
        return this.getFieldType();
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public Class getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public Class getFieldType() {
        return this.field.getType();
    }

    @Override
    public Set<Class> getConcernedTypes() {
        return ClassUtils.getConcernedTypes(this.field);
    }

    public String toStringAttribute() {
        return this.field.getDeclaringClass().getName() + "." + this.field.getName();
    }

    @Override
    public Optional<Link> getLink() {
        return Optional.ofNullable(this.link);
    }

    public ClassAttribute setLink(Link link) {
        this.link = link;
        return this;
    }
}

