/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml.classdiagram;

import ch.ifocusit.plantuml.PlantUmlBuilder;
import ch.ifocusit.plantuml.classdiagram.LinkMaker;
import ch.ifocusit.plantuml.classdiagram.model.Association;
import ch.ifocusit.plantuml.classdiagram.model.attribute.ClassAttribute;
import ch.ifocusit.plantuml.classdiagram.model.clazz.JavaClazz;
import ch.ifocusit.plantuml.classdiagram.model.method.ClassMethod;
import ch.ifocusit.plantuml.utils.ClassUtils;
import ch.ifocusit.plantuml.utils.PlantUmlUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class AbstractClassDiagramBuilder
implements LinkMaker {
    private Predicate<ClassAttribute> additionalFieldPredicate = a -> !a.getName().equals("ENUM$VALUES");
    private static final List<String> DEFAULT_METHODS_EXCLUDED = List.of("equals", "hashCode", "toString");
    private Predicate<ClassMethod> additionalMethodPredicate = m -> !DEFAULT_METHODS_EXCLUDED.contains(m.getName()) && ClassUtils.isNotGetterSetter(m.getMethod());
    protected final PlantUmlBuilder builder = new PlantUmlBuilder();
    protected final Set<JavaClazz> clazzes = new TreeSet<JavaClazz>();
    protected final Set<Association> detectedAssociations = new HashSet<Association>();
    protected LinkMaker linkMaker = this;
    private String[] startOptions;
    private String[] endOptions;
    private String header;
    private String title;
    private String footer;
    private final Map<Class, JavaClazz> cache = new HashMap<Class, JavaClazz>();
    protected boolean withDependencies = false;
    protected boolean hideSelfLink = true;

    public <B extends AbstractClassDiagramBuilder> B setHeader(String header) {
        this.header = header;
        return (B)this;
    }

    public <B extends AbstractClassDiagramBuilder> B setTitle(String title) {
        this.title = title;
        return (B)this;
    }

    public <B extends AbstractClassDiagramBuilder> B setStartOptions(String ... lines) {
        this.startOptions = lines;
        return (B)this;
    }

    public <B extends AbstractClassDiagramBuilder> B setEndOptions(String ... lines) {
        this.endOptions = lines;
        return (B)this;
    }

    public <B extends AbstractClassDiagramBuilder> B setFooter(String footer) {
        this.footer = footer;
        return (B)this;
    }

    public <B extends AbstractClassDiagramBuilder> B excludes(String ... excludes) {
        Predicate<ClassAttribute> notMatchField = field -> Stream.of(excludes).noneMatch(excl -> field.toStringAttribute().matches((String)excl));
        this.additionalFieldPredicate = this.additionalFieldPredicate.and(notMatchField);
        Predicate<ClassMethod> notMatchMethod = field -> Stream.of(excludes).noneMatch(excl -> field.toStringMethod().matches((String)excl));
        this.additionalMethodPredicate = this.additionalMethodPredicate.and(notMatchMethod);
        return (B)this;
    }

    public <B extends AbstractClassDiagramBuilder> B addFieldPredicate(Predicate<ClassAttribute> predicate) {
        this.additionalFieldPredicate = this.additionalFieldPredicate.and(predicate);
        return (B)this;
    }

    public <B extends AbstractClassDiagramBuilder> B addMethodPredicate(Predicate<ClassMethod> predicate) {
        this.additionalMethodPredicate = this.additionalMethodPredicate.and(predicate);
        return (B)this;
    }

    public <B extends AbstractClassDiagramBuilder> B withLinkMaker(LinkMaker linkMaker) {
        this.linkMaker = linkMaker;
        return (B)this;
    }

    public String build() {
        this.readClasses();
        this.detectAssociations();
        this.builder.start(this.startOptions);
        this.builder.appendHeader(this.header);
        this.builder.appendTitle(this.title);
        this.addPackages();
        this.addTypes();
        this.addAssociations();
        this.builder.appendFooter(this.footer);
        this.builder.end(this.endOptions);
        return this.builder.build();
    }

    public abstract void addPackages();

    public abstract void detectAssociations();

    public boolean hideFields(JavaClazz javaClazz) {
        return PlantUmlUtils.hideFields(javaClazz, this.header) || PlantUmlUtils.hideFields(javaClazz, this.footer);
    }

    public boolean hideMethods(JavaClazz javaClazz) {
        return PlantUmlUtils.hideMethods(javaClazz, this.header) || PlantUmlUtils.hideMethods(javaClazz, this.footer);
    }

    public abstract void readClasses();

    public void addTypes() {
        this.clazzes.forEach(this.builder::addType);
    }

    public Predicate<ClassAttribute> filterFields() {
        return this.additionalFieldPredicate;
    }

    public Predicate<ClassMethod> filterMethods() {
        return this.additionalMethodPredicate;
    }

    public void addAssociations() {
        this.detectedAssociations.stream().sorted().forEach(this.builder::addAssociation);
    }

    public <B extends AbstractClassDiagramBuilder> B withDependencies(boolean flag) {
        this.withDependencies = flag;
        return (B)this;
    }

    public <B extends AbstractClassDiagramBuilder> B hideSelfLink() {
        this.hideSelfLink = true;
        return (B)this;
    }

    public <B extends AbstractClassDiagramBuilder> B showSelfLink() {
        this.hideSelfLink = false;
        return (B)this;
    }

    public <B extends AbstractClassDiagramBuilder> B withDependencies() {
        return this.withDependencies(true);
    }
}

