/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.plantuml.classdiagram.model.clazz;

import ch.ifocusit.plantuml.classdiagram.model.Link;
import ch.ifocusit.plantuml.classdiagram.model.attribute.ClassAttribute;
import ch.ifocusit.plantuml.classdiagram.model.clazz.Clazz;
import ch.ifocusit.plantuml.classdiagram.model.method.ClassMethod;
import ch.ifocusit.plantuml.utils.ClassUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class JavaClazz
implements Clazz {
    private final Class<?> relatedClass;
    private String overridedName;
    private Link link;
    private final List<ClassAttribute> attributes = new ArrayList<ClassAttribute>();
    private final List<ClassMethod> methods = new ArrayList<ClassMethod>();
    private String backgroundColor;
    private String borderColor;

    public JavaClazz(Class<?> relatedClass) {
        this.relatedClass = relatedClass;
    }

    @Override
    public String getName() {
        return Optional.ofNullable(this.overridedName).orElse(ClassUtils.getSimpleName(this.relatedClass));
    }

    @Override
    public Clazz.Type getType() {
        return this.parseType(this.relatedClass);
    }

    @Override
    public Optional<Link> getLink() {
        return Optional.ofNullable(this.link);
    }

    public JavaClazz setLink(Link link) {
        this.link = link;
        return this;
    }

    public Class<?> getRelatedClass() {
        return this.relatedClass;
    }

    public List<ClassAttribute> getAttributes() {
        return this.attributes;
    }

    public void addAttributes(ClassAttribute ... attributes) {
        this.attributes.addAll(Arrays.asList(attributes));
    }

    public List<ClassMethod> getMethods() {
        return this.methods;
    }

    public void addMethods(ClassMethod ... methods) {
        this.methods.addAll(Arrays.asList(methods));
    }

    public JavaClazz setOverridedName(String overridedName) {
        this.overridedName = overridedName;
        return this;
    }

    private Clazz.Type parseType(Class aClass) {
        if (aClass.isInterface()) {
            return Clazz.Type.INTERFACE;
        }
        if (aClass.isEnum()) {
            return Clazz.Type.ENUM;
        }
        if (Modifier.isAbstract(aClass.getModifiers())) {
            return Clazz.Type.ABSTRACT;
        }
        return Clazz.Type.CLASS;
    }

    @Override
    public Optional<String> getBackgroundColor() {
        return Optional.ofNullable(this.backgroundColor);
    }

    @Override
    public Optional<String> getBorderColor() {
        return Optional.ofNullable(this.borderColor);
    }

    public JavaClazz setBackgroundColor(String color) {
        this.backgroundColor = color;
        return this;
    }

    public JavaClazz setBorderColor(String color) {
        this.borderColor = color;
        return this;
    }

    public static JavaClazz from(Class aClass, ClassAttribute[] attributes, ClassMethod[] methods) {
        JavaClazz javaClass = new JavaClazz(aClass);
        javaClass.addAttributes(attributes);
        javaClass.addMethods(methods);
        return javaClass;
    }
}

