/*
 * Decompiled with CFR 0.152.
 */
package ch.iterial.keycloak.plugins.directus;

import java.util.Locale;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.keycloak.Config;

public record DirectusConnectionConfig(String url, String token, String realm, String role, String provider, long ttl, SyncConfig sync, boolean valid) {
    @Override
    public String toString() {
        return new StringJoiner(", ", DirectusConnectionConfig.class.getSimpleName() + "[", "]").add("url='" + this.url + "'").add("token='" + (this.token == null ? "null" : "********") + "'").add("realm='" + this.realm + "'").add("role='" + this.role + "'").add("provider='" + this.provider + "'").add("ttl=" + this.ttl).add("sync=" + String.valueOf(this.sync)).toString();
    }

    public static DirectusConnectionConfig fromScope(Config.Scope scope) {
        AtomicBoolean validity = new AtomicBoolean(true);
        String url = PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.URL);
        String token = PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.TOKEN);
        String realm = PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.REALM);
        String role = PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.ROLE);
        String provider = PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.PROVIDER);
        Long ttl = PropertyReaderFactory.forLong(scope, validity).getValue(PropertyNames.TTL);
        Boolean syncCreate = PropertyReaderFactory.forBoolean(scope, validity).getValue(PropertyNames.SYNC_CREATE);
        Boolean syncUpdate = PropertyReaderFactory.forBoolean(scope, validity).getValue(PropertyNames.SYNC_UPDATE);
        Boolean syncDelete = PropertyReaderFactory.forBoolean(scope, validity).getValue(PropertyNames.SYNC_DELETE);
        return new DirectusConnectionConfig(PropertyUtils.trimToNull(url), PropertyUtils.trimToNull(token), PropertyUtils.trimToNull(realm), PropertyUtils.trimToNull(role), PropertyUtils.trimToNull(provider), PropertyUtils.toFinite(ttl), new SyncConfig(PropertyUtils.isTrue(syncCreate), PropertyUtils.isTrue(syncUpdate), PropertyUtils.isTrue(syncDelete)), validity.get());
    }

    public record SyncConfig(boolean create, boolean update, boolean delete) {
        @Override
        public String toString() {
            return new StringJoiner(", ", SyncConfig.class.getSimpleName() + "[", "]").add("create=" + this.create).add("update=" + this.update).add("delete=" + this.delete).toString();
        }
    }

    private static abstract class PropertyReaderFactory {
        private PropertyReaderFactory() {
        }

        static PropertyReader<String> forString(Config.Scope scope, AtomicBoolean validity) {
            return new PropertyReader<String>((arg_0, arg_1) -> ((Config.Scope)scope).get(arg_0, arg_1), PropertyUtils::trimToNull, validity);
        }

        static PropertyReader<Long> forLong(Config.Scope scope, AtomicBoolean validity) {
            return new PropertyReader<Long>((arg_0, arg_1) -> ((Config.Scope)scope).getLong(arg_0, arg_1), value -> value == null ? null : Long.valueOf(value), validity);
        }

        static PropertyReader<Boolean> forBoolean(Config.Scope scope, AtomicBoolean validity) {
            return new PropertyReader<Boolean>((arg_0, arg_1) -> ((Config.Scope)scope).getBoolean(arg_0, arg_1), value -> Boolean.TRUE.toString().equalsIgnoreCase(PropertyUtils.trimToNull(value)), validity);
        }
    }

    private record PropertyReader<T>(BiFunction<String, T, T> reader, Function<String, T> converter, AtomicBoolean validity) {
        public T getValue(PropertyNames property) {
            T value = this.reader.apply(property.getKey(), (String)this.converter.apply(PropertyReader.getSystemPropertiesValue(property)));
            boolean invalid = value == null && property.isRequired();
            this.validity.set(this.validity.get() && !invalid);
            return value;
        }

        private static String getSystemPropertiesValue(PropertyNames propertyName) {
            return PropertyUtils.trimToNull(System.getenv(propertyName.getEnvVariableName()));
        }
    }

    public static enum PropertyNames {
        URL(true),
        TOKEN(true),
        REALM(false),
        ROLE(false),
        PROVIDER(false),
        TTL(false),
        SYNC_CREATE(false),
        SYNC_UPDATE(false),
        SYNC_DELETE(false);

        private final boolean required;

        private PropertyNames(boolean required) {
            this.required = required;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getKey() {
            return this.name().toLowerCase(Locale.ENGLISH).replace("_", "-");
        }

        private String getEnvVariableName() {
            return "KC_DIRECTUS_" + this.name();
        }
    }

    private static abstract class PropertyUtils {
        private PropertyUtils() {
        }

        static long toFinite(Long value) {
            return value == null ? -1L : value;
        }

        static boolean isTrue(Boolean value) {
            return value != null && value != false;
        }

        static String trimToNull(String string) {
            if (string == null) {
                return null;
            }
            String trimmed = string.trim();
            if (trimmed.isEmpty()) {
                return null;
            }
            return trimmed;
        }
    }
}

