/*
 * Decompiled with CFR 0.152.
 */
package ch.iterial.keycloak.plugins.directus;

import ch.iterial.keycloak.plugins.directus.DirectusConnectionConfig;
import ch.iterial.keycloak.plugins.directus.UserRoleDto;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class UserRoleService {
    private static final Logger LOGGER = Logger.getLogger(UserRoleService.class);
    private final DirectusConnectionConfig connectionConfig;
    private final KeycloakSessionFactory keycloakSessionFactory;

    public UserRoleService(DirectusConnectionConfig connectionConfig, KeycloakSessionFactory keycloakSessionFactory) {
        this.connectionConfig = connectionConfig;
        this.keycloakSessionFactory = keycloakSessionFactory;
    }

    public UserRoleDto getUser(AdminEvent event) {
        String userPath = event.getResourcePath();
        String[] userIdTokens = userPath.split("/");
        if (userIdTokens.length < 2 || !userIdTokens[0].equalsIgnoreCase("users")) {
            throw new IllegalArgumentException("Invalid user resource path: " + userPath);
        }
        String userId = userIdTokens[1];
        return (UserRoleDto)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)this.keycloakSessionFactory, session -> {
            RealmModel userRealm = session.realms().getRealm(event.getRealmId());
            UserModel user = session.users().getUserById(userRealm, userId);
            if (user == null) {
                return new UserRoleDto(userId, null, null, null, "active", null, null);
            }
            Set<RoleModel> userRoles = UserRoleService.extractUserRoles(user);
            String roleName = this.connectionConfig.role();
            String providerName = this.connectionConfig.provider() == null ? "keycloak" : this.connectionConfig.provider();
            return new UserRoleDto(user.getId(), user.getFirstName(), user.getLastName(), user.getEmail(), "active", providerName, userRoles.stream().filter(role -> roleName == null || role.getName().equalsIgnoreCase(roleName)).findFirst().map(role -> role.getFirstAttribute("directus_id")).orElse(null));
        });
    }

    private static Set<RoleModel> extractUserRoles(UserModel user) {
        HashSet<RoleModel> userRoles = new HashSet<RoleModel>();
        user.getRoleMappingsStream().filter(role -> !role.isComposite()).forEach(role -> {
            LOGGER.info((Object)String.format("User '%s' has non-composite role '%s'", user.getEmail(), role.getName()));
            userRoles.add((RoleModel)role);
        });
        user.getGroupsStream().forEach(group -> {
            LOGGER.info((Object)String.format("User '%s' has group '%s'", user.getEmail(), group.getName()));
            group.getRoleMappingsStream().filter(role -> !role.isComposite()).forEach(role -> {
                LOGGER.info((Object)String.format("Group '%s' has non-composite role '%s'", group.getName(), role.getName()));
                userRoles.add((RoleModel)role);
            });
        });
        return userRoles;
    }
}

