package ch.iterial.keycloak.plugins.directus;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

public record UserRoleDto(@JsonProperty("external_identifier") String userId,
                          @JsonProperty("first_name") String firstName,
                          @JsonProperty("last_name") String lastName,
                          @JsonProperty("email") String email,
                          @JsonProperty("status") String status,
                          @JsonProperty("provider") String provider,
                          @JsonProperty("role") String roleId) implements Serializable {
    public static final String STATUS_ACTIVE = "active";
    public static final String ATTRIBUTE_DIRECTUS_ID = "directus_id";
}
