package ch.iterial.keycloak.plugins.directus;

import org.jboss.logging.Logger;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class UserRoleUtils {
    private static final Logger LOGGER = Logger.getLogger(UserRoleUtils.class);

    public static Set<RoleModel> extractUserRoles(final UserModel user) {
        final Set<RoleModel> userRoles = new HashSet<>();

        user.getRoleMappingsStream().filter(role -> !role.isComposite()).forEach(role -> {
            LOGGER.info(String.format("User '%s' has non-composite role '%s'", user.getEmail(), role.getName()));
            userRoles.add(role);
        });
        user.getGroupsStream().forEach(group -> {
            LOGGER.info(String.format("User '%s' has group '%s'", user.getEmail(), group.getName()));
            group.getRoleMappingsStream().filter(role -> !role.isComposite()).forEach(role -> {
                LOGGER.info(String.format("Group '%s' has non-composite role '%s'", group.getName(), role.getName()));
                userRoles.add(role);
            });
        });

        return userRoles;
    }

    public static boolean roleNameMatches(final String[] roleNames, final RoleModel role) {
        final boolean emptyRoleNames = roleNames == null || roleNames.length == 0;
        if (role == null) {
            return emptyRoleNames;
        }
        return emptyRoleNames
                || Arrays.stream(roleNames).anyMatch(roleName -> roleName.equalsIgnoreCase(role.getName()));
    }
}
