/*
 * Decompiled with CFR 0.152.
 */
package ch.iterial.keycloak.plugins.directus;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.keycloak.Config;

public record DirectusConnectionConfig(String url, String token, String realm, String[] roles, String provider, long ttl, SyncConfig sync, boolean valid) {
    private static final String PROVIDER_KEYCLOAK = "keycloak";
    private static final Predicate<String[]> ARRAY_NOT_EMPTY = array -> array != null && ((String[])array).length > 0;

    @Override
    public String toString() {
        return new StringJoiner(", ", DirectusConnectionConfig.class.getSimpleName() + "[", "]").add("url='" + this.url + "'").add("token='" + (this.token == null ? "null" : "********") + "'").add("realm='" + this.realm + "'").add("roles='" + (this.roles == null ? "[]" : Arrays.stream(this.roles).collect(Collectors.joining(",", "[", "]"))) + "'").add("provider='" + this.provider + "'").add("ttl=" + this.ttl).add("sync=" + String.valueOf(this.sync)).toString();
    }

    public static DirectusConnectionConfig fromScope(Config.Scope scope) {
        AtomicBoolean validity = new AtomicBoolean(true);
        String url = PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.URL);
        String token = PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.TOKEN);
        String realm = PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.REALM);
        String role = PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.ROLE);
        String[] roles = PropertyReaderFactory.forStrings(scope, validity).getValue(PropertyNames.ROLES);
        String provider = PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.PROVIDER);
        Long ttl = PropertyReaderFactory.forLong(scope, validity).getValue(PropertyNames.TTL);
        Boolean syncCreate = PropertyReaderFactory.forBoolean(scope, validity).getValue(PropertyNames.SYNC_CREATE);
        Boolean syncUpdate = PropertyReaderFactory.forBoolean(scope, validity).getValue(PropertyNames.SYNC_UPDATE);
        Boolean syncDelete = PropertyReaderFactory.forBoolean(scope, validity).getValue(PropertyNames.SYNC_DELETE);
        return new DirectusConnectionConfig(PropertyUtils.trimToNull(url), PropertyUtils.trimToNull(token), PropertyUtils.trimToNull(realm), Optional.of(roles).filter(ARRAY_NOT_EMPTY).orElseGet(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }), Optional.ofNullable(PropertyUtils.trimToNull(provider)).orElse(PROVIDER_KEYCLOAK), PropertyUtils.toFinite(ttl), new SyncConfig(PropertyUtils.isTrue(syncCreate), PropertyUtils.isTrue(syncUpdate), PropertyUtils.isTrue(syncDelete)), validity.get());
    }

    public record SyncConfig(boolean create, boolean update, boolean delete) {
        @Override
        public String toString() {
            return new StringJoiner(", ", SyncConfig.class.getSimpleName() + "[", "]").add("create=" + this.create).add("update=" + this.update).add("delete=" + this.delete).toString();
        }
    }

    private static abstract class PropertyReaderFactory {
        private PropertyReaderFactory() {
        }

        static PropertyReader<String> forString(Config.Scope scope, AtomicBoolean validity) {
            return new PropertyReader<String>((arg_0, arg_1) -> ((Config.Scope)scope).get(arg_0, arg_1), PropertyUtils::trimToNull, validity);
        }

        static PropertyReader<String[]> forStrings(Config.Scope scope, AtomicBoolean validity) {
            return new PropertyReader<String[]>((key, fallback) -> Optional.ofNullable(scope.getArray(key)).filter(ARRAY_NOT_EMPTY).orElse((String[])fallback), PropertyUtils::toEmptyArray, validity);
        }

        static PropertyReader<Long> forLong(Config.Scope scope, AtomicBoolean validity) {
            return new PropertyReader<Long>((arg_0, arg_1) -> ((Config.Scope)scope).getLong(arg_0, arg_1), value -> value == null ? null : Long.valueOf(value), validity);
        }

        static PropertyReader<Boolean> forBoolean(Config.Scope scope, AtomicBoolean validity) {
            return new PropertyReader<Boolean>((arg_0, arg_1) -> ((Config.Scope)scope).getBoolean(arg_0, arg_1), value -> Boolean.TRUE.toString().equalsIgnoreCase(PropertyUtils.trimToNull(value)), validity);
        }
    }

    private record PropertyReader<T>(BiFunction<String, T, T> reader, Function<String, T> converter, AtomicBoolean validity) {
        public T getValue(PropertyNames property) {
            T value = this.reader.apply(property.getKey(), (String)this.converter.apply(PropertyReader.getSystemPropertiesValue(property)));
            boolean invalid = value == null && property.isRequired();
            this.validity.set(this.validity.get() && !invalid);
            return value;
        }

        private static String getSystemPropertiesValue(PropertyNames propertyName) {
            return PropertyUtils.trimToNull(System.getenv(propertyName.getEnvVariableName()));
        }
    }

    public static enum PropertyNames {
        URL(true),
        TOKEN(true),
        REALM(false),
        ROLE(false),
        ROLES(false),
        PROVIDER(false),
        TTL(false),
        SYNC_CREATE(false),
        SYNC_UPDATE(false),
        SYNC_DELETE(false);

        private final boolean required;

        private PropertyNames(boolean required) {
            this.required = required;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getKey() {
            return this.name().toLowerCase(Locale.ENGLISH).replace("_", "-");
        }

        private String getEnvVariableName() {
            return "KC_DIRECTUS_" + this.name();
        }
    }

    private static abstract class PropertyUtils {
        private PropertyUtils() {
        }

        static long toFinite(Long value) {
            return value == null ? -1L : value;
        }

        static boolean isTrue(Boolean value) {
            return value != null && value != false;
        }

        static String trimToNull(String string) {
            if (string == null) {
                return null;
            }
            String trimmed = string.trim();
            if (trimmed.isEmpty()) {
                return null;
            }
            return trimmed;
        }

        static String[] toEmptyArray(String array) {
            return array == null ? new String[]{} : (String[])Arrays.stream(array.split(",")).map(PropertyUtils::trimToNull).filter(Objects::nonNull).toArray(String[]::new);
        }
    }
}

