/*
 * Decompiled with CFR 0.152.
 */
package ch.iterial.keycloak.plugins.directus;

import ch.iterial.keycloak.plugins.directus.DirectusConnectionConfig;
import ch.iterial.keycloak.plugins.directus.UserRoleDto;
import ch.iterial.keycloak.plugins.directus.UserRoleUtils;
import java.util.Set;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class UserRoleService {
    private final DirectusConnectionConfig connectionConfig;
    private final KeycloakSessionFactory keycloakSessionFactory;

    public UserRoleService(DirectusConnectionConfig connectionConfig, KeycloakSessionFactory keycloakSessionFactory) {
        this.connectionConfig = connectionConfig;
        this.keycloakSessionFactory = keycloakSessionFactory;
    }

    public UserRoleDto getUser(AdminEvent event) {
        String userPath = event.getResourcePath();
        String[] userIdTokens = userPath.split("/");
        if (userIdTokens.length < 2 || !userIdTokens[0].equalsIgnoreCase("users")) {
            throw new IllegalArgumentException("Invalid user resource path: " + userPath);
        }
        String userId = userIdTokens[1];
        return (UserRoleDto)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)this.keycloakSessionFactory, session -> {
            RealmModel userRealm = session.realms().getRealm(event.getRealmId());
            UserModel user = session.users().getUserById(userRealm, userId);
            if (user == null) {
                return new UserRoleDto(userId, null, null, null, "active", null, null);
            }
            Set<RoleModel> userRoles = UserRoleUtils.extractUserRoles(user);
            String[] configRoleNames = this.connectionConfig.roles();
            String configProviderName = this.connectionConfig.provider();
            return new UserRoleDto(user.getId(), user.getFirstName(), user.getLastName(), user.getEmail(), "active", configProviderName, userRoles.stream().filter(role -> UserRoleUtils.roleNameMatches(configRoleNames, role)).findFirst().map(role -> role.getFirstAttribute("directus_id")).orElse(null));
        });
    }
}

