/*
 * Decompiled with CFR 0.152.
 */
package ch.iterial.keycloak.plugins.directus;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public class UserRoleUtils {
    private static final Logger LOGGER = Logger.getLogger(UserRoleUtils.class);

    public static Set<RoleModel> extractUserRoles(UserModel user) {
        HashSet<RoleModel> userRoles = new HashSet<RoleModel>();
        user.getRoleMappingsStream().filter(role -> !role.isComposite()).forEach(role -> {
            LOGGER.info((Object)String.format("User '%s' has non-composite role '%s'", user.getEmail(), role.getName()));
            userRoles.add((RoleModel)role);
        });
        user.getGroupsStream().forEach(group -> {
            LOGGER.info((Object)String.format("User '%s' has group '%s'", user.getEmail(), group.getName()));
            group.getRoleMappingsStream().filter(role -> !role.isComposite()).forEach(role -> {
                LOGGER.info((Object)String.format("Group '%s' has non-composite role '%s'", group.getName(), role.getName()));
                userRoles.add((RoleModel)role);
            });
        });
        return userRoles;
    }

    public static boolean roleNameMatches(String[] roleNames, RoleModel role) {
        boolean emptyRoleNames;
        boolean bl = emptyRoleNames = roleNames == null || roleNames.length == 0;
        if (role == null) {
            return emptyRoleNames;
        }
        return emptyRoleNames || Arrays.stream(roleNames).anyMatch(roleName -> roleName.equalsIgnoreCase(role.getName()));
    }
}

