/*
 * Decompiled with CFR 0.152.
 */
package ch.iterial.keycloak.plugins.directus;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.keycloak.Config;

public record DirectusConnectionConfig(String url, String token, String realm, RoleConfig[] roles, String provider, long ttl, SyncConfig sync, boolean valid) {
    private static final String PROVIDER_KEYCLOAK = "keycloak";
    private static final Predicate<String[]> ARRAY_NOT_EMPTY = array -> array != null && ((String[])array).length > 0;

    @Override
    public String toString() {
        return new StringJoiner(", ", DirectusConnectionConfig.class.getSimpleName() + "[", "]").add("url='" + this.url + "'").add("token='" + (this.token == null ? "null" : "********") + "'").add("realm='" + this.realm + "'").add("roles='" + (this.roles == null ? "[]" : Arrays.stream(this.roles).map(RoleConfig::toString).collect(Collectors.joining(",", "[", "]"))) + "'").add("provider='" + this.provider + "'").add("ttl=" + this.ttl).add("sync=" + String.valueOf(this.sync)).toString();
    }

    public static DirectusConnectionConfig fromScope(Config.Scope scope) {
        AtomicBoolean validity = new AtomicBoolean(true);
        String url = PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.URL, new String[0]);
        String token = PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.TOKEN, new String[0]);
        String realm = PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.REALM, new String[0]);
        String[] roles = PropertyReaderFactory.forStrings(scope, validity).getValue(PropertyNames.ROLES, new String[0]);
        String provider = PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.PROVIDER, new String[0]);
        Long ttl = PropertyReaderFactory.forLong(scope, validity).getValue(PropertyNames.TTL, new String[0]);
        Boolean syncCreate = PropertyReaderFactory.forBoolean(scope, validity).getValue(PropertyNames.SYNC_CREATE, new String[0]);
        Boolean syncUpdate = PropertyReaderFactory.forBoolean(scope, validity).getValue(PropertyNames.SYNC_UPDATE, new String[0]);
        Boolean syncDelete = PropertyReaderFactory.forBoolean(scope, validity).getValue(PropertyNames.SYNC_DELETE, new String[0]);
        return new DirectusConnectionConfig(PropertyUtils.trimToNull(url), PropertyUtils.trimToNull(token), PropertyUtils.trimToNull(realm), Optional.of(roles).filter(ARRAY_NOT_EMPTY).map(roleNames -> (RoleConfig[])Arrays.stream(roleNames).map(roleName -> new RoleConfig((String)roleName, PropertyReaderFactory.forString(scope, validity).getValue(PropertyNames.ROLE_$key_ID, (String)roleName))).toArray(RoleConfig[]::new)).orElse(new RoleConfig[0]), Optional.ofNullable(PropertyUtils.trimToNull(provider)).orElse(PROVIDER_KEYCLOAK), PropertyUtils.toFinite(ttl), new SyncConfig(PropertyUtils.isTrue(syncCreate), PropertyUtils.isTrue(syncUpdate), PropertyUtils.isTrue(syncDelete)), validity.get());
    }

    public record RoleConfig(String name, String directusId) {
        @Override
        public String toString() {
            return new StringJoiner(", ", RoleConfig.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("directusID='" + this.directusId + "'").toString();
        }
    }

    public record SyncConfig(boolean create, boolean update, boolean delete) {
        @Override
        public String toString() {
            return new StringJoiner(", ", SyncConfig.class.getSimpleName() + "[", "]").add("create=" + this.create).add("update=" + this.update).add("delete=" + this.delete).toString();
        }
    }

    private static abstract class PropertyReaderFactory {
        private PropertyReaderFactory() {
        }

        static PropertyReader<String> forString(Config.Scope scope, AtomicBoolean validity) {
            return new PropertyReader<String>((arg_0, arg_1) -> ((Config.Scope)scope).get(arg_0, arg_1), PropertyUtils::trimToNull, validity);
        }

        static PropertyReader<String[]> forStrings(Config.Scope scope, AtomicBoolean validity) {
            return new PropertyReader<String[]>((key, fallback) -> Optional.ofNullable(scope.getArray(key)).filter(ARRAY_NOT_EMPTY).orElse((String[])fallback), PropertyUtils::toEmptyArray, validity);
        }

        static PropertyReader<Long> forLong(Config.Scope scope, AtomicBoolean validity) {
            return new PropertyReader<Long>((arg_0, arg_1) -> ((Config.Scope)scope).getLong(arg_0, arg_1), value -> value == null ? null : Long.valueOf(value), validity);
        }

        static PropertyReader<Boolean> forBoolean(Config.Scope scope, AtomicBoolean validity) {
            return new PropertyReader<Boolean>((arg_0, arg_1) -> ((Config.Scope)scope).getBoolean(arg_0, arg_1), value -> Boolean.TRUE.toString().equalsIgnoreCase(PropertyUtils.trimToNull(value)), validity);
        }
    }

    private record PropertyReader<T>(BiFunction<String, T, T> reader, Function<String, T> converter, AtomicBoolean validity) {
        public T getValue(PropertyNames property, String ... values) {
            T value = this.reader.apply(property.getKey(values), (String)this.converter.apply(PropertyReader.getSystemPropertiesValue(property, new String[0])));
            boolean invalid = value == null && property.isRequired();
            this.validity.set(this.validity.get() && !invalid);
            return value;
        }

        private static String getSystemPropertiesValue(PropertyNames propertyName, String ... values) {
            return PropertyUtils.trimToNull(System.getenv(propertyName.getEnvVariableName(values)));
        }
    }

    public static enum PropertyNames {
        URL(true),
        TOKEN(true),
        REALM(false),
        ROLES(false),
        ROLE_$key_ID(false),
        PROVIDER(false),
        TTL(false),
        SYNC_CREATE(false),
        SYNC_UPDATE(false),
        SYNC_DELETE(false);

        private final boolean required;

        private PropertyNames(boolean required) {
            this.required = required;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getKey(String ... values) {
            return PropertyNames.underscoreToDash(this.getEnumFullName(values).toLowerCase(Locale.ENGLISH));
        }

        public String getEnvVariableName(String ... values) {
            return "KC_DIRECTUS_" + PropertyNames.dashToUnderscore(this.getEnumFullName(values).toUpperCase(Locale.ENGLISH));
        }

        private String getEnumFullName(String ... values) {
            String name = this.name();
            if (name.contains("_$key_") && values.length > 0) {
                return name.replace("_$key_", "_" + values[0] + "_");
            }
            return name;
        }

        private static String underscoreToDash(String string) {
            return string == null ? null : string.trim().replaceAll("\\s+", "-").replace("_", "-");
        }

        private static String dashToUnderscore(String string) {
            return string == null ? null : string.trim().replaceAll("\\s+", "_").replace("-", "_");
        }
    }

    private static abstract class PropertyUtils {
        private PropertyUtils() {
        }

        static long toFinite(Long value) {
            return value == null ? -1L : value;
        }

        static boolean isTrue(Boolean value) {
            return value != null && value != false;
        }

        static String trimToNull(String string) {
            if (string == null) {
                return null;
            }
            String trimmed = string.trim();
            if (trimmed.isEmpty()) {
                return null;
            }
            return trimmed;
        }

        static String[] toEmptyArray(String array) {
            return array == null ? new String[]{} : (String[])Arrays.stream(array.split(",")).map(PropertyUtils::trimToNull).filter(Objects::nonNull).toArray(String[]::new);
        }
    }
}

