package ch.iterial.keycloak.plugins.directus;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jboss.logging.Logger;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;

public class DirectusNotifier {

    private static final Logger LOGGER = Logger.getLogger(DirectusNotifier.class);

    private final CloseableHttpClient httpClient;
    private final DirectusConnectionConfig connectionConfig;
    private final ObjectMapper objectMapper;

    public DirectusNotifier(final CloseableHttpClient httpClient,
                            final DirectusConnectionConfig connectionConfig) {
        this.httpClient = httpClient;
        this.connectionConfig = connectionConfig;
        this.objectMapper = new ObjectMapper();
    }

    public void notifyCreate(final UserRoleDto data) throws IOException {
        final HttpPost request = new HttpPost();
        request.setURI(URI.create(connectionConfig.url() + "/users"));
        request.setEntity(new StringEntity(objectMapper.writeValueAsString(data), ContentType.APPLICATION_JSON));

        httpClient.execute(request, response -> {
            final int responseCode = response.getStatusLine().getStatusCode();
            try (final InputStream stream = response.getEntity().getContent()) {
                final String responseBody = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                if (isSuccessful(responseCode)) {
                    throw new IOException("Unable to create new user on Directus: " + responseBody);
                } else {
                    LOGGER.info("Successfully created new user on Directus: " + responseBody);
                }
            }
            return Void.class;
        });
    }

    private static boolean isSuccessful(final int responseCode) {
        return responseCode < 200 || responseCode > 299;
    }
}
