/*
 * Decompiled with CFR 0.152.
 */
package ch.iterial.keycloak.plugins.directus;

import ch.iterial.keycloak.plugins.directus.DirectusConnectionConfig;
import ch.iterial.keycloak.plugins.directus.DirectusEventListenerProvider;
import ch.iterial.keycloak.plugins.directus.DirectusNotifier;
import ch.iterial.keycloak.plugins.directus.UserRoleService;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class DirectusEventListenerProviderFactory
implements EventListenerProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(DirectusEventListenerProviderFactory.class);
    private static final String PROVIDER_ID = "directus-integration";
    private PoolingHttpClientConnectionManager connectionManager = null;
    private CloseableHttpClient httpClient = null;
    private DirectusNotifier directusNotifier = null;
    private UserRoleService userRoleService = null;
    private DirectusConnectionConfig connectionConfig = null;

    public EventListenerProvider create(KeycloakSession keycloakSession) {
        LOGGER.debug((Object)("Creating event listener provider: " + keycloakSession.toString()));
        return new DirectusEventListenerProvider(this.directusNotifier, this.userRoleService, this.connectionConfig, keycloakSession);
    }

    public void init(Config.Scope scope) {
        LOGGER.info((Object)("Factory init with scope: " + scope.getPropertyNames().stream().collect(Collectors.joining(",", "[", "]"))));
        this.connectionConfig = DirectusConnectionConfig.fromScope(scope);
        LOGGER.info((Object)String.format("Loaded %s config: " + String.valueOf(this.connectionConfig), this.connectionConfig.valid() ? "valid" : "invalid"));
        this.configureHttpClient(this.connectionConfig);
        this.directusNotifier = new DirectusNotifier(this.httpClient, this.connectionConfig);
    }

    public void postInit(KeycloakSessionFactory keycloakSessionFactory) {
        LOGGER.info((Object)"Post init factory");
        this.userRoleService = new UserRoleService(this.connectionConfig, keycloakSessionFactory);
    }

    public void close() {
        LOGGER.info((Object)"Closing factory");
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
            if (this.connectionManager != null) {
                this.connectionManager.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error closing http client", (Throwable)e);
        }
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(DirectusConnectionConfig.PropertyNames.URL.getKey(new String[0])).label("Directus base URL").type("String").required(true).add().property().name(DirectusConnectionConfig.PropertyNames.TOKEN.getKey(new String[0])).label("Directus admin user token").type("String").required(true).secret(true).add().property().name(DirectusConnectionConfig.PropertyNames.ROLES.getKey(new String[0])).label("Keycloak role names").type("List").required(true).add().property().name(DirectusConnectionConfig.PropertyNames.ROLE_$key_ID.getKey(new String[0])).label("Directus role ID").type("String").required(true).add().property().name(DirectusConnectionConfig.PropertyNames.PROVIDER.getKey(new String[0])).label("Directus auth provider name").type("String").required(true).add().property().name(DirectusConnectionConfig.PropertyNames.REALM.getKey(new String[0])).label("Keycloak realm").type("String").add().property().name(DirectusConnectionConfig.PropertyNames.TTL.getKey(new String[0])).label("Request TTL in milliseconds").type("String").add().property().name(DirectusConnectionConfig.PropertyNames.SYNC_CREATE.getKey(new String[0])).label("Should sync user creation").type("boolean").defaultValue((Object)false).add().property().name(DirectusConnectionConfig.PropertyNames.SYNC_UPDATE.getKey(new String[0])).label("Should sync user update").type("boolean").defaultValue((Object)false).add().property().name(DirectusConnectionConfig.PropertyNames.SYNC_DELETE.getKey(new String[0])).label("Should sync user deletion").type("boolean").defaultValue((Object)false).add().build();
    }

    private synchronized void configureHttpClient(DirectusConnectionConfig connectionConfig) {
        this.connectionManager = new PoolingHttpClientConnectionManager(connectionConfig.ttl(), TimeUnit.MILLISECONDS);
        this.httpClient = HttpClientBuilder.create().setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE).setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultClientConnectionReuseStrategy.INSTANCE).setConnectionManager((HttpClientConnectionManager)this.connectionManager).setDefaultHeaders(Set.of(new BasicHeader("Content-Type", ContentType.APPLICATION_JSON.toString()), new BasicHeader("Authorization", "Bearer " + connectionConfig.token()))).build();
    }
}

